/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.ConciseBitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.spatial.ImmutableRTree;
import org.apache.druid.common.utils.SerializerUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.smoosh.Smoosh;
import org.apache.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.MMappedIndex;
import org.apache.druid.segment.Metadata;
import org.apache.druid.segment.MetricHolder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexIndexableAdapter;
import org.apache.druid.segment.RowPointer;
import org.apache.druid.segment.SegmentLazyLoadFailCallback;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.segment.SegmentValidationException;
import org.apache.druid.segment.SimpleQueryableIndex;
import org.apache.druid.segment.TransformableRowIterator;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.column.ColumnDescriptor;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.BitmapSerde;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ColumnarMultiInts;
import org.apache.druid.segment.data.CompressedColumnarLongsSupplier;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.ImmutableRTreeObjectStrategy;
import org.apache.druid.segment.data.IndexedIterable;
import org.apache.druid.segment.data.VSizeColumnarMultiInts;
import org.apache.druid.segment.serde.ComplexColumnPartSupplier;
import org.apache.druid.segment.serde.DictionaryEncodedColumnSupplier;
import org.apache.druid.segment.serde.DictionaryEncodedStringIndexSupplier;
import org.apache.druid.segment.serde.FloatNumericColumnSupplier;
import org.apache.druid.segment.serde.LongNumericColumnSupplier;
import org.joda.time.Interval;

public class IndexIO {
    public static final byte V8_VERSION = 8;
    public static final byte V9_VERSION = 9;
    public static final int CURRENT_VERSION_ID = 9;
    public static final BitmapSerdeFactory LEGACY_FACTORY = new BitmapSerde.LegacyBitmapSerdeFactory();
    public static final ByteOrder BYTE_ORDER = ByteOrder.nativeOrder();
    static final SerializerUtils SERIALIZER_UTILS = new SerializerUtils();
    private final Map<Integer, IndexLoader> indexLoaders;
    private static final EmittingLogger log = new EmittingLogger(IndexIO.class);
    private final ObjectMapper mapper;

    @Inject
    public IndexIO(ObjectMapper mapper, ColumnConfig columnConfig) {
        this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper, (Object)"null ObjectMapper");
        Preconditions.checkNotNull((Object)columnConfig, (Object)"null ColumnConfig");
        ImmutableMap.Builder indexLoadersBuilder = ImmutableMap.builder();
        LegacyIndexLoader legacyIndexLoader = new LegacyIndexLoader(new DefaultIndexIOHandler(), columnConfig);
        for (int i = 0; i <= 8; ++i) {
            indexLoadersBuilder.put((Object)i, (Object)legacyIndexLoader);
        }
        indexLoadersBuilder.put((Object)9, (Object)new V9IndexLoader(columnConfig));
        this.indexLoaders = indexLoadersBuilder.build();
    }

    public void validateTwoSegments(File dir1, File dir2) throws IOException {
        try (QueryableIndex queryableIndex1 = this.loadIndex(dir1);
             QueryableIndex queryableIndex2 = this.loadIndex(dir2);){
            this.validateTwoSegments(new QueryableIndexIndexableAdapter(queryableIndex1), new QueryableIndexIndexableAdapter(queryableIndex2));
        }
    }

    public void validateTwoSegments(IndexableAdapter adapter1, IndexableAdapter adapter2) {
        HashSet metNames2;
        HashSet dimNames2;
        if (adapter1.getNumRows() != adapter2.getNumRows()) {
            throw new SegmentValidationException("Row count mismatch. Expected [%d] found [%d]", adapter1.getNumRows(), adapter2.getNumRows());
        }
        HashSet dimNames1 = Sets.newHashSet(adapter1.getDimensionNames());
        if (!dimNames1.equals(dimNames2 = Sets.newHashSet(adapter2.getDimensionNames()))) {
            throw new SegmentValidationException("Dimension names differ. Expected [%s] found [%s]", dimNames1, dimNames2);
        }
        HashSet metNames1 = Sets.newHashSet(adapter1.getMetricNames());
        if (!metNames1.equals(metNames2 = Sets.newHashSet(adapter2.getMetricNames()))) {
            throw new SegmentValidationException("Metric names differ. Expected [%s] found [%s]", metNames1, metNames2);
        }
        try (TransformableRowIterator it1 = adapter1.getRows();
             TransformableRowIterator it2 = adapter2.getRows();){
            long row = 0L;
            while (it1.moveToNext()) {
                if (!it2.moveToNext()) {
                    throw new SegmentValidationException("Unexpected end of second adapter", new Object[0]);
                }
                RowPointer rp1 = it1.getPointer();
                RowPointer rp2 = it2.getPointer();
                ++row;
                if (rp1.getRowNum() != rp2.getRowNum()) {
                    throw new SegmentValidationException("Row number mismatch: [%d] vs [%d]", rp1.getRowNum(), rp2.getRowNum());
                }
                try {
                    IndexIO.validateRowValues(rp1, adapter1, rp2, adapter2);
                }
                catch (SegmentValidationException ex) {
                    throw new SegmentValidationException(ex, "Validation failure on row %d: [%s] vs [%s]", row, rp1, rp2);
                }
            }
            if (it2.moveToNext()) {
                throw new SegmentValidationException("Unexpected end of first adapter", new Object[0]);
            }
            if (row != (long)adapter1.getNumRows()) {
                throw new SegmentValidationException("Actual Row count mismatch. Expected [%d] found [%d]", row, adapter1.getNumRows());
            }
        }
    }

    public QueryableIndex loadIndex(File inDir) throws IOException {
        return this.loadIndex(inDir, false, SegmentLazyLoadFailCallback.NOOP);
    }

    public QueryableIndex loadIndex(File inDir, boolean lazy, SegmentLazyLoadFailCallback loadFailed) throws IOException {
        int version = SegmentUtils.getVersionFromDir((File)inDir);
        IndexLoader loader = this.indexLoaders.get(version);
        if (loader != null) {
            return loader.load(inDir, this.mapper, lazy, loadFailed);
        }
        throw new ISE("Unknown index version[%s]", new Object[]{version});
    }

    public static void checkFileSize(File indexFile) throws IOException {
        long fileSize = indexFile.length();
        if (fileSize > Integer.MAX_VALUE) {
            throw new IOE("File[%s] too large[%d]", new Object[]{indexFile, fileSize});
        }
    }

    private static void validateRowValues(RowPointer rp1, IndexableAdapter adapter1, RowPointer rp2, IndexableAdapter adapter2) {
        if (rp1.getTimestamp() != rp2.getTimestamp()) {
            throw new SegmentValidationException("Timestamp mismatch. Expected %d found %d", rp1.getTimestamp(), rp2.getTimestamp());
        }
        List<Object> dims1 = rp1.getDimensionValuesForDebug();
        List<Object> dims2 = rp2.getDimensionValuesForDebug();
        if (dims1.size() != dims2.size()) {
            throw new SegmentValidationException("Dim lengths not equal %s vs %s", dims1, dims2);
        }
        List<String> dim1Names = adapter1.getDimensionNames();
        List<String> dim2Names = adapter2.getDimensionNames();
        int dimCount = dims1.size();
        for (int i = 0; i < dimCount; ++i) {
            ColumnType dim2Type;
            String dim1Name = dim1Names.get(i);
            String dim2Name = dim2Names.get(i);
            ColumnCapabilities capabilities1 = adapter1.getCapabilities(dim1Name);
            ColumnCapabilities capabilities2 = adapter2.getCapabilities(dim2Name);
            ColumnType dim1Type = capabilities1.toColumnType();
            if (!Objects.equals(dim1Type, dim2Type = capabilities2.toColumnType())) {
                throw new SegmentValidationException("Dim [%s] types not equal. Expected %d found %d", dim1Name, dim1Type, dim2Type);
            }
            Object vals1 = dims1.get(i);
            Object vals2 = dims2.get(i);
            if (IndexIO.isNullRow(vals1) ^ IndexIO.isNullRow(vals2)) {
                throw IndexIO.notEqualValidationException(dim1Name, vals1, vals2);
            }
            boolean vals1IsList = vals1 instanceof List;
            boolean vals2IsList = vals2 instanceof List;
            if (!(vals1IsList ^ vals2IsList ? (vals1IsList ? ((List)vals1).size() != 1 || !Objects.equals(((List)vals1).get(0), vals2) : ((List)vals2).size() != 1 || !Objects.equals(((List)vals2).get(0), vals1)) : !Objects.equals(vals1, vals2))) continue;
            throw IndexIO.notEqualValidationException(dim1Name, vals1, vals2);
        }
    }

    private static boolean isNullRow(@Nullable Object row) {
        if (row == null) {
            return true;
        }
        if (!(row instanceof List)) {
            return false;
        }
        List rowAsList = (List)row;
        int rowSize = rowAsList.size();
        for (int i = 0; i < rowSize; ++i) {
            Object v = rowAsList.get(i);
            if (v == null) continue;
            return false;
        }
        return true;
    }

    private static SegmentValidationException notEqualValidationException(String dimName, Object v1, Object v2) {
        return new SegmentValidationException("Dim [%s] values not equal. Expected %s found %s", dimName, v1, v2);
    }

    public static File makeDimFile(File dir, String dimension) {
        return new File(dir, StringUtils.format((String)"dim_%s.drd", (Object[])new Object[]{dimension}));
    }

    public static File makeTimeFile(File dir, ByteOrder order) {
        return new File(dir, StringUtils.format((String)"time_%s.drd", (Object[])new Object[]{order}));
    }

    public static File makeMetricFile(File dir, String metricName, ByteOrder order) {
        return new File(dir, StringUtils.format((String)"met_%s_%s.drd", (Object[])new Object[]{metricName, order}));
    }

    static class V9IndexLoader
    implements IndexLoader {
        private final ColumnConfig columnConfig;

        V9IndexLoader(ColumnConfig columnConfig) {
            this.columnConfig = columnConfig;
        }

        @Override
        public QueryableIndex load(File inDir, ObjectMapper mapper, boolean lazy, SegmentLazyLoadFailCallback loadFailed) throws IOException {
            GenericIndexed<String> finalDims;
            GenericIndexed<String> finalCols;
            GenericIndexed<String> allDims;
            GenericIndexed<String> allCols;
            BitmapSerdeFactory segmentBitmapSerdeFactory;
            log.debug("Mapping v9 index[%s]", new Object[]{inDir});
            long startTime = System.currentTimeMillis();
            int theVersion = Ints.fromByteArray((byte[])Files.toByteArray((File)new File(inDir, "version.bin")));
            if (theVersion != 9) {
                throw new IAE("Expected version[9], got[%d]", new Object[]{theVersion});
            }
            SmooshedFileMapper smooshedFiles = Smoosh.map((File)inDir);
            ByteBuffer indexBuffer = smooshedFiles.mapFile("index.drd");
            GenericIndexed<String> nonNullCols = GenericIndexed.read(indexBuffer, GenericIndexed.STRING_STRATEGY, smooshedFiles);
            GenericIndexed<String> nonNullDims = GenericIndexed.read(indexBuffer, GenericIndexed.STRING_STRATEGY, smooshedFiles);
            Interval dataInterval = Intervals.utc((long)indexBuffer.getLong(), (long)indexBuffer.getLong());
            if (indexBuffer.hasRemaining()) {
                segmentBitmapSerdeFactory = (BitmapSerdeFactory)mapper.readValue(SERIALIZER_UTILS.readString(indexBuffer), BitmapSerdeFactory.class);
                if (indexBuffer.hasRemaining()) {
                    allCols = GenericIndexed.read(indexBuffer, GenericIndexed.STRING_STRATEGY, smooshedFiles);
                    allDims = GenericIndexed.read(indexBuffer, GenericIndexed.STRING_STRATEGY, smooshedFiles);
                } else {
                    allCols = null;
                    allDims = null;
                }
            } else {
                segmentBitmapSerdeFactory = new BitmapSerde.LegacyBitmapSerdeFactory();
                allCols = null;
                allDims = null;
            }
            Metadata metadata = null;
            ByteBuffer metadataBB = smooshedFiles.mapFile("metadata.drd");
            if (metadataBB != null) {
                try {
                    metadata = (Metadata)mapper.readValue(SERIALIZER_UTILS.readBytes(metadataBB, metadataBB.remaining()), Metadata.class);
                }
                catch (JsonParseException | JsonMappingException ex) {
                    log.warn(ex, "Failed to load metadata for segment [%s]", new Object[]{inDir});
                }
                catch (IOException ex) {
                    throw new IOException("Failed to read metadata", ex);
                }
            }
            LinkedHashMap<String, Supplier<ColumnHolder>> columns = new LinkedHashMap<String, Supplier<ColumnHolder>>();
            ByteBuffer timeBuffer = smooshedFiles.mapFile("__time");
            this.registerColumnHolder(lazy, columns, "__time", mapper, timeBuffer, smooshedFiles, loadFailed);
            if (allCols != null) {
                List<String> mergedCols = this.restoreColumns(nonNullCols, allCols);
                List<String> mergedDims = this.restoreColumns(nonNullDims, allDims);
                finalCols = GenericIndexed.fromIterable(mergedCols, GenericIndexed.STRING_STRATEGY);
                finalDims = GenericIndexed.fromIterable(mergedDims, GenericIndexed.STRING_STRATEGY);
            } else {
                finalCols = nonNullCols;
                finalDims = nonNullDims;
            }
            this.registerColumnHolders(inDir, finalCols, lazy, columns, mapper, smooshedFiles, loadFailed);
            SimpleQueryableIndex index = new SimpleQueryableIndex(dataInterval, finalDims, segmentBitmapSerdeFactory.getBitmapFactory(), columns, smooshedFiles, metadata, lazy);
            log.debug("Mapped v9 index[%s] in %,d millis", new Object[]{inDir, System.currentTimeMillis() - startTime});
            return index;
        }

        private List<String> restoreColumns(GenericIndexed<String> nonNullCols, GenericIndexed<String> allCols) {
            ArrayList<String> mergedCols = new ArrayList<String>(allCols.size());
            Iterator<String> allColsIterator = allCols.iterator();
            Iterator<String> nonNullColsIterator = nonNullCols.iterator();
            while (allColsIterator.hasNext()) {
                String next = allColsIterator.next();
                if (next == null) {
                    Preconditions.checkState((boolean)nonNullColsIterator.hasNext(), (Object)"There is no more column name to iterate in nonNullColsIterator while allColsIterator expects one. This is likely a potential bug in creating this segment. Try reingesting your data with storeEmptyColumns setting to false in task context.");
                    mergedCols.add(nonNullColsIterator.next());
                    continue;
                }
                mergedCols.add(next);
            }
            return mergedCols;
        }

        private void registerColumnHolders(File inDir, GenericIndexed<String> cols, boolean lazy, Map<String, Supplier<ColumnHolder>> columns, ObjectMapper mapper, SmooshedFileMapper smooshedFiles, SegmentLazyLoadFailCallback loadFailed) throws IOException {
            for (String columnName : cols) {
                if (Strings.isNullOrEmpty((String)columnName)) {
                    log.warn("Null or Empty Dimension found in the file : " + inDir, new Object[0]);
                    continue;
                }
                ByteBuffer colBuffer = smooshedFiles.mapFile(columnName);
                this.registerColumnHolder(lazy, columns, columnName, mapper, colBuffer, smooshedFiles, loadFailed);
            }
        }

        private void registerColumnHolder(boolean lazy, Map<String, Supplier<ColumnHolder>> columns, String columnName, ObjectMapper mapper, ByteBuffer colBuffer, SmooshedFileMapper smooshedFiles, SegmentLazyLoadFailCallback loadFailed) throws IOException {
            if (lazy) {
                columns.put(columnName, (Supplier<ColumnHolder>)Suppliers.memoize(() -> {
                    try {
                        return this.deserializeColumn(columnName, mapper, colBuffer, smooshedFiles);
                    }
                    catch (IOException | RuntimeException e) {
                        log.warn((Throwable)e, "Throw exceptions when deserialize column [%s].", new Object[]{columnName});
                        loadFailed.execute();
                        throw Throwables.propagate((Throwable)e);
                    }
                }));
            } else {
                ColumnHolder columnHolder = this.deserializeColumn(columnName, mapper, colBuffer, smooshedFiles);
                columns.put(columnName, (Supplier<ColumnHolder>)((Supplier)() -> columnHolder));
            }
        }

        @VisibleForTesting
        ColumnHolder deserializeColumn(String columnName, ObjectMapper mapper, ByteBuffer byteBuffer, SmooshedFileMapper smooshedFiles) throws IOException {
            ColumnDescriptor serde = (ColumnDescriptor)mapper.readValue(SERIALIZER_UTILS.readString(byteBuffer), ColumnDescriptor.class);
            return serde.read(byteBuffer, this.columnConfig, smooshedFiles);
        }
    }

    static class LegacyIndexLoader
    implements IndexLoader {
        private final IndexIOHandler legacyHandler;
        private final ColumnConfig columnConfig;

        LegacyIndexLoader(IndexIOHandler legacyHandler, ColumnConfig columnConfig) {
            this.legacyHandler = legacyHandler;
            this.columnConfig = columnConfig;
        }

        @Override
        public QueryableIndex load(File inDir, ObjectMapper mapper, boolean lazy, SegmentLazyLoadFailCallback loadFailed) throws IOException {
            MMappedIndex index = this.legacyHandler.mapDir(inDir);
            LinkedHashMap<String, Supplier<ColumnHolder>> columns = new LinkedHashMap<String, Supplier<ColumnHolder>>();
            for (String dimension : index.getAvailableDimensions()) {
                ColumnBuilder builder = new ColumnBuilder().setType(ValueType.STRING).setHasMultipleValues(true).setDictionaryEncodedColumnSupplier(new DictionaryEncodedColumnSupplier(index.getDimValueLookup(dimension), index.getDimValueUtf8Lookup(dimension), null, (Supplier<ColumnarMultiInts>)Suppliers.ofInstance((Object)index.getDimColumn(dimension)), this.columnConfig.columnCacheSizeBytes()));
                GenericIndexed<ImmutableBitmap> bitmaps = index.getBitmapIndexes().get(dimension);
                ImmutableRTree spatialIndex = index.getSpatialIndexes().get(dimension);
                builder.setIndexSupplier(new DictionaryEncodedStringIndexSupplier(new ConciseBitmapFactory(), index.getDimValueLookup(dimension), index.getDimValueUtf8Lookup(dimension), bitmaps, spatialIndex), bitmaps != null, spatialIndex != null);
                columns.put(dimension, this.getColumnHolderSupplier(builder, lazy));
            }
            for (String metric : index.getAvailableMetrics()) {
                ColumnBuilder builder;
                MetricHolder metricHolder = index.getMetricHolder(metric);
                if (metricHolder.getType() == MetricHolder.MetricType.FLOAT) {
                    builder = new ColumnBuilder().setType(ValueType.FLOAT).setNumericColumnSupplier(new FloatNumericColumnSupplier(metricHolder.floatType, LEGACY_FACTORY.getBitmapFactory().makeEmptyImmutableBitmap()));
                    columns.put(metric, this.getColumnHolderSupplier(builder, lazy));
                    continue;
                }
                if (metricHolder.getType() != MetricHolder.MetricType.COMPLEX) continue;
                builder = new ColumnBuilder().setType(ValueType.COMPLEX).setComplexColumnSupplier(new ComplexColumnPartSupplier(metricHolder.getTypeName(), metricHolder.complexType));
                columns.put(metric, this.getColumnHolderSupplier(builder, lazy));
            }
            ColumnBuilder builder = new ColumnBuilder().setType(ValueType.LONG).setNumericColumnSupplier(new LongNumericColumnSupplier(index.timestamps, LEGACY_FACTORY.getBitmapFactory().makeEmptyImmutableBitmap()));
            columns.put("__time", this.getColumnHolderSupplier(builder, lazy));
            return new SimpleQueryableIndex(index.getDataInterval(), index.getAvailableDimensions(), new ConciseBitmapFactory(), columns, index.getFileMapper(), null, lazy);
        }

        private Supplier<ColumnHolder> getColumnHolderSupplier(ColumnBuilder builder, boolean lazy) {
            if (lazy) {
                return Suppliers.memoize(builder::build);
            }
            ColumnHolder columnHolder = builder.build();
            return () -> columnHolder;
        }
    }

    static interface IndexLoader {
        public QueryableIndex load(File var1, ObjectMapper var2, boolean var3, SegmentLazyLoadFailCallback var4) throws IOException;
    }

    public static class DefaultIndexIOHandler
    implements IndexIOHandler {
        private static final Logger log = new Logger(DefaultIndexIOHandler.class);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MMappedIndex mapDir(File inDir) throws IOException {
            log.debug("Mapping v8 index[%s]", new Object[]{inDir});
            long startTime = System.currentTimeMillis();
            FileInputStream indexIn = null;
            try {
                indexIn = new FileInputStream(new File(inDir, "index.drd"));
                byte theVersion = (byte)((InputStream)indexIn).read();
                if (theVersion != 8) {
                    throw new IAE("Unknown version[%d]", new Object[]{theVersion});
                }
            }
            catch (Throwable throwable) {
                Closeables.close(indexIn, (boolean)false);
                throw throwable;
            }
            Closeables.close((Closeable)indexIn, (boolean)false);
            SmooshedFileMapper smooshedFiles = Smoosh.map((File)inDir);
            ByteBuffer indexBuffer = smooshedFiles.mapFile("index.drd");
            indexBuffer.get();
            GenericIndexed<String> availableDimensions = GenericIndexed.read(indexBuffer, GenericIndexed.STRING_STRATEGY, smooshedFiles);
            GenericIndexed<String> availableMetrics = GenericIndexed.read(indexBuffer, GenericIndexed.STRING_STRATEGY, smooshedFiles);
            Interval dataInterval = Intervals.of((String)SERIALIZER_UTILS.readString(indexBuffer));
            BitmapSerde.LegacyBitmapSerdeFactory bitmapSerdeFactory = new BitmapSerde.LegacyBitmapSerdeFactory();
            CompressedColumnarLongsSupplier timestamps = CompressedColumnarLongsSupplier.fromByteBuffer(smooshedFiles.mapFile(IndexIO.makeTimeFile(inDir, BYTE_ORDER).getName()), BYTE_ORDER);
            LinkedHashMap metrics = Maps.newLinkedHashMap();
            for (String metric : availableMetrics) {
                String metricFilename;
                MetricHolder holder;
                if (!metric.equals((holder = MetricHolder.fromByteBuffer(smooshedFiles.mapFile(metricFilename = IndexIO.makeMetricFile(inDir, metric, BYTE_ORDER).getName()))).getName())) {
                    throw new ISE("Metric[%s] loaded up metric[%s] from disk.  File names do matter.", new Object[]{metric, holder.getName()});
                }
                metrics.put(metric, holder);
            }
            HashMap<String, GenericIndexed<String>> dimValueLookups = new HashMap<String, GenericIndexed<String>>();
            HashMap<String, GenericIndexed<ByteBuffer>> dimValueUtf8Lookups = new HashMap<String, GenericIndexed<ByteBuffer>>();
            HashMap<String, VSizeColumnarMultiInts> dimColumns = new HashMap<String, VSizeColumnarMultiInts>();
            HashMap<String, GenericIndexed<ImmutableBitmap>> bitmaps = new HashMap<String, GenericIndexed<ImmutableBitmap>>();
            for (String dimension : IndexedIterable.create(availableDimensions)) {
                ByteBuffer dimBuffer = smooshedFiles.mapFile(IndexIO.makeDimFile(inDir, dimension).getName());
                String fileDimensionName = SERIALIZER_UTILS.readString(dimBuffer);
                Preconditions.checkState((boolean)dimension.equals(fileDimensionName), (String)"Dimension file[%s] has dimension[%s] in it!?", (Object[])new Object[]{IndexIO.makeDimFile(inDir, dimension), fileDimensionName});
                dimValueLookups.put(dimension, GenericIndexed.read(dimBuffer.duplicate(), GenericIndexed.STRING_STRATEGY));
                dimValueUtf8Lookups.put(dimension, GenericIndexed.read(dimBuffer, GenericIndexed.BYTE_BUFFER_STRATEGY));
                dimColumns.put(dimension, VSizeColumnarMultiInts.readFromByteBuffer(dimBuffer));
            }
            ByteBuffer invertedBuffer = smooshedFiles.mapFile("inverted.drd");
            for (int i = 0; i < availableDimensions.size(); ++i) {
                bitmaps.put(SERIALIZER_UTILS.readString(invertedBuffer), GenericIndexed.read(invertedBuffer, bitmapSerdeFactory.getObjectStrategy()));
            }
            HashMap<String, ImmutableRTree> spatialIndexed = new HashMap<String, ImmutableRTree>();
            ByteBuffer spatialBuffer = smooshedFiles.mapFile("spatial.drd");
            while (spatialBuffer != null && spatialBuffer.hasRemaining()) {
                spatialIndexed.put(SERIALIZER_UTILS.readString(spatialBuffer), (ImmutableRTree)new ImmutableRTreeObjectStrategy(bitmapSerdeFactory.getBitmapFactory()).fromByteBufferWithSize(spatialBuffer));
            }
            MMappedIndex retVal = new MMappedIndex(availableDimensions, availableMetrics, dataInterval, timestamps, metrics, dimValueLookups, dimValueUtf8Lookups, dimColumns, bitmaps, spatialIndexed, smooshedFiles);
            log.debug("Mapped v8 index[%s] in %,d millis", new Object[]{inDir, System.currentTimeMillis() - startTime});
            return retVal;
        }
    }

    static interface IndexIOHandler {
        public MMappedIndex mapDir(File var1) throws IOException;
    }
}

