/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.RangeIndexedInts;
import org.apache.druid.segment.filter.BooleanValueMatcher;
import org.apache.druid.segment.historical.HistoricalDimensionSelector;

public class ConstantMultiValueDimensionSelector
implements HistoricalDimensionSelector {
    private final List<String> values;
    private final RangeIndexedInts row;

    public ConstantMultiValueDimensionSelector(List<String> values) {
        this.values = values;
        this.row = new RangeIndexedInts();
        this.row.setSize(values.size());
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("values", this.values);
        inspector.visit("row", this.row);
    }

    @Override
    @Nullable
    public Object getObject() {
        return this.defaultGetObject();
    }

    @Override
    public Class<?> classOfObject() {
        return Object.class;
    }

    @Override
    public int getValueCardinality() {
        return -1;
    }

    @Override
    @Nullable
    public String lookupName(int id) {
        return this.values.get(id);
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return true;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return null;
    }

    @Override
    public IndexedInts getRow() {
        return this.row;
    }

    @Override
    public ValueMatcher makeValueMatcher(@Nullable String value) {
        return BooleanValueMatcher.of(this.values.stream().anyMatch(v -> Objects.equals(value, v)));
    }

    @Override
    public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
        return BooleanValueMatcher.of(this.values.stream().anyMatch(arg_0 -> predicate.apply(arg_0)));
    }

    @Override
    public IndexedInts getRow(int offset) {
        return this.row;
    }
}

