/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Predicate;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ZeroIndexedInts;
import org.apache.druid.segment.filter.BooleanValueMatcher;
import org.apache.druid.segment.historical.SingleValueHistoricalDimensionSelector;

public class ConstantDimensionSelector
implements SingleValueHistoricalDimensionSelector,
IdLookup {
    private final String value;

    public ConstantDimensionSelector(String value) {
        if (NullHandling.isNullOrEquivalent((String)value)) {
            throw new IllegalArgumentException("Use DimensionSelector.constant(null)");
        }
        this.value = value;
    }

    @Override
    public IndexedInts getRow() {
        return ZeroIndexedInts.instance();
    }

    @Override
    public int getRowValue(int offset) {
        return 0;
    }

    @Override
    public IndexedInts getRow(int offset) {
        return this.getRow();
    }

    @Override
    public ValueMatcher makeValueMatcher(String matchValue) {
        return BooleanValueMatcher.of(Objects.equals(this.value, matchValue));
    }

    @Override
    public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
        return BooleanValueMatcher.of(predicate.apply((Object)this.value));
    }

    @Override
    public int getValueCardinality() {
        return 1;
    }

    @Override
    public String lookupName(int id) {
        assert (id == 0) : "id = " + id;
        return this.value;
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return true;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return this;
    }

    @Override
    public int lookupId(String name) {
        return this.value.equals(name) ? 0 : -1;
    }

    @Override
    @Nullable
    public Object getObject() {
        return this.value;
    }

    @Override
    public Class classOfObject() {
        return String.class;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("value", this.value);
    }
}

