/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.io.Closeable;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.selector.settable.SettableColumnValueSelector;

public class ColumnCache
implements ColumnSelector {
    private final HashMap<String, ColumnHolder> holderCache;
    private final QueryableIndex index;
    private final Closer closer;

    public ColumnCache(QueryableIndex index, Closer closer) {
        this.index = index;
        this.closer = closer;
        this.holderCache = new HashMap();
    }

    @Override
    public List<String> getColumnNames() {
        return this.index.getColumnNames();
    }

    @Override
    @Nullable
    public ColumnHolder getColumnHolder(String columnName) {
        return this.holderCache.computeIfAbsent(columnName, dimension -> {
            final ColumnHolder holder = this.index.getColumnHolder(columnName);
            if (holder == null) {
                return null;
            }
            return new ColumnHolder(){
                @Nullable
                private BaseColumn theColumn = null;

                @Override
                public ColumnCapabilities getCapabilities() {
                    return holder.getCapabilities();
                }

                @Override
                public int getLength() {
                    return holder.getLength();
                }

                @Override
                public BaseColumn getColumn() {
                    if (this.theColumn == null) {
                        this.theColumn = (BaseColumn)ColumnCache.this.closer.register((Closeable)holder.getColumn());
                    }
                    return this.theColumn;
                }

                @Override
                @Nullable
                public ColumnIndexSupplier getIndexSupplier() {
                    return holder.getIndexSupplier();
                }

                @Override
                public SettableColumnValueSelector makeNewSettableColumnValueSelector() {
                    return holder.makeNewSettableColumnValueSelector();
                }
            };
        });
    }

    @Nullable
    public BaseColumn getColumn(String columnName) {
        ColumnHolder retVal = this.getColumnHolder(columnName);
        return retVal == null ? null : retVal.getColumn();
    }
}

