/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.spec;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.joda.time.Interval;

public class MultipleSpecificSegmentSpec
implements QuerySegmentSpec {
    private final List<SegmentDescriptor> descriptors;
    private volatile List<Interval> intervals = null;

    @JsonCreator
    public MultipleSpecificSegmentSpec(@JsonProperty(value="segments") List<SegmentDescriptor> descriptors) {
        this.descriptors = descriptors;
    }

    @JsonProperty(value="segments")
    public List<SegmentDescriptor> getDescriptors() {
        return this.descriptors;
    }

    @Override
    public List<Interval> getIntervals() {
        if (this.intervals != null) {
            return this.intervals;
        }
        this.intervals = JodaUtils.condenseIntervals((Iterable)Iterables.transform(this.descriptors, input -> input.getInterval()));
        return this.intervals;
    }

    @Override
    public <T> QueryRunner<T> lookup(Query<T> query, QuerySegmentWalker walker) {
        return walker.getQueryRunnerForSegments(query, this.descriptors);
    }

    public String toString() {
        return "MultipleSpecificSegmentSpec{descriptors=" + this.descriptors + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultipleSpecificSegmentSpec that = (MultipleSpecificSegmentSpec)o;
        return Objects.equals(this.descriptors, that.descriptors);
    }

    public int hashCode() {
        return Objects.hash(this.descriptors);
    }
}

