/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.column;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.GrouperBufferComparatorUtils;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorStrategy;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.segment.ColumnValueSelector;

public class NullableNumericGroupByColumnSelectorStrategy
implements GroupByColumnSelectorStrategy {
    private final GroupByColumnSelectorStrategy delegate;
    private final byte[] nullKeyBytes;

    public NullableNumericGroupByColumnSelectorStrategy(GroupByColumnSelectorStrategy delegate) {
        this.delegate = delegate;
        this.nullKeyBytes = new byte[delegate.getGroupingKeySize() + 1];
        this.nullKeyBytes[0] = 1;
    }

    @Override
    public int getGroupingKeySize() {
        return this.delegate.getGroupingKeySize() + 1;
    }

    @Override
    public void processValueFromGroupingKey(GroupByColumnSelectorPlus selectorPlus, ByteBuffer key, ResultRow resultRow, int keyBufferPosition) {
        if (key.get(keyBufferPosition) == 1) {
            resultRow.set(selectorPlus.getResultRowPosition(), null);
        } else {
            this.delegate.processValueFromGroupingKey(selectorPlus, key, resultRow, keyBufferPosition + 1);
        }
    }

    @Override
    public int initColumnValues(ColumnValueSelector selector, int columnIndex, Object[] values) {
        if (selector.isNull()) {
            values[columnIndex] = null;
            return 0;
        }
        return this.delegate.initColumnValues(selector, columnIndex, values);
    }

    @Override
    public int writeToKeyBuffer(int keyBufferPosition, ColumnValueSelector selector, ByteBuffer keyBuffer) {
        if (selector.isNull()) {
            keyBuffer.position(keyBufferPosition);
            keyBuffer.put(this.nullKeyBytes);
            return 0;
        }
        keyBuffer.put(keyBufferPosition, (byte)0);
        return this.delegate.writeToKeyBuffer(keyBufferPosition + 1, selector, keyBuffer);
    }

    @Override
    public Grouper.BufferComparator bufferComparator(int keyBufferPosition, @Nullable StringComparator stringComparator) {
        return GrouperBufferComparatorUtils.makeNullHandlingBufferComparatorForNumericData(keyBufferPosition, this.delegate.bufferComparator(keyBufferPosition + 1, stringComparator));
    }

    @Override
    public void initGroupingKeyColumnValue(int keyBufferPosition, int dimensionIndex, Object rowObj, ByteBuffer keyBuffer, int[] stack) {
        if (rowObj == null) {
            keyBuffer.position(keyBufferPosition);
            keyBuffer.put(this.nullKeyBytes);
        } else {
            keyBuffer.put(keyBufferPosition, (byte)0);
            this.delegate.initGroupingKeyColumnValue(keyBufferPosition + 1, dimensionIndex, rowObj, keyBuffer, stack);
        }
    }

    @Override
    public boolean checkRowIndexAndAddValueToGroupingKey(int keyBufferPosition, Object rowObj, int rowValIdx, ByteBuffer keyBuffer) {
        return false;
    }

    @Override
    public void reset() {
        this.delegate.reset();
    }
}

