/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae.column;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.GrouperBufferComparatorUtils;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorPlus;
import org.apache.druid.query.groupby.epinephelinae.column.GroupByColumnSelectorStrategy;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;

public class DoubleGroupByColumnSelectorStrategy
implements GroupByColumnSelectorStrategy {
    @Override
    public int getGroupingKeySize() {
        return 8;
    }

    @Override
    public void processValueFromGroupingKey(GroupByColumnSelectorPlus selectorPlus, ByteBuffer key, ResultRow resultRow, int keyBufferPosition) {
        double val = key.getDouble(keyBufferPosition);
        resultRow.set(selectorPlus.getResultRowPosition(), val);
    }

    @Override
    public int initColumnValues(ColumnValueSelector selector, int columnIndex, Object[] values) {
        values[columnIndex] = selector.getDouble();
        return 0;
    }

    @Override
    public int writeToKeyBuffer(int keyBufferPosition, ColumnValueSelector selector, ByteBuffer keyBuffer) {
        keyBuffer.putDouble(keyBufferPosition, selector.getDouble());
        return 0;
    }

    @Override
    public void initGroupingKeyColumnValue(int keyBufferPosition, int dimensionIndex, Object rowObj, ByteBuffer keyBuffer, int[] stack) {
        this.writeToKeyBuffer(keyBufferPosition, DimensionHandlerUtils.nullToZero((Double)rowObj), keyBuffer);
        stack[dimensionIndex] = 1;
    }

    @Override
    public boolean checkRowIndexAndAddValueToGroupingKey(int keyBufferPosition, Object rowObj, int rowValIdx, ByteBuffer keyBuffer) {
        return false;
    }

    @Override
    public Grouper.BufferComparator bufferComparator(int keyBufferPosition, @Nullable StringComparator stringComparator) {
        return GrouperBufferComparatorUtils.makeBufferComparatorForDouble(keyBufferPosition, true, stringComparator);
    }

    @Override
    public void reset() {
    }

    private void writeToKeyBuffer(int keyBufferPosition, double value, ByteBuffer keyBuffer) {
        keyBuffer.putDouble(keyBufferPosition, value);
    }
}

