/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.druid.query.groupby.epinephelinae.Groupers;

public interface Grouper<KeyType>
extends Closeable {
    public void init();

    public boolean isInitialized();

    public AggregateResult aggregate(KeyType var1, int var2);

    default public AggregateResult aggregate(KeyType key) {
        Preconditions.checkNotNull(key, (Object)"key");
        return this.aggregate(key, this.hashFunction().applyAsInt(key));
    }

    public void reset();

    default public ToIntFunction<KeyType> hashFunction() {
        return Groupers::hashObject;
    }

    @Override
    public void close();

    public CloseableIterator<Entry<KeyType>> iterator(boolean var1);

    public static interface BufferComparator {
        public int compare(ByteBuffer var1, ByteBuffer var2, int var3, int var4);
    }

    public static interface KeySerde<T> {
        public int keySize();

        public Class<T> keyClazz();

        public List<String> getDictionary();

        @Nullable
        public ByteBuffer toByteBuffer(T var1);

        public T createKey();

        public void readFromByteBuffer(T var1, ByteBuffer var2, int var3);

        public BufferComparator bufferComparator();

        public BufferComparator bufferComparatorWithAggregators(AggregatorFactory[] var1, int[] var2);

        public void reset();
    }

    public static interface KeySerdeFactory<T> {
        public long getMaxDictionarySize();

        public KeySerde<T> factorize();

        public KeySerde<T> factorizeWithDictionary(List<String> var1);

        public T copyKey(T var1);

        public Comparator<Entry<T>> objectComparator(boolean var1);
    }

    public static interface Entry<T> {
        public T getKey();

        public Object[] getValues();
    }
}

