/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter.vector;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.vector.BaseVectorValueMatcher;
import org.apache.druid.query.filter.vector.BooleanVectorValueMatcher;
import org.apache.druid.query.filter.vector.ReadableVectorMatch;
import org.apache.druid.query.filter.vector.VectorMatch;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcherFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;

public class ObjectVectorValueMatcher
implements VectorValueMatcherFactory {
    protected final VectorObjectSelector selector;

    public ObjectVectorValueMatcher(VectorObjectSelector selector) {
        this.selector = selector;
    }

    @Override
    public VectorValueMatcher makeMatcher(@Nullable String value) {
        return BooleanVectorValueMatcher.of(this.selector, value == null);
    }

    @Override
    public VectorValueMatcher makeMatcher(DruidPredicateFactory predicateFactory) {
        final Predicate<Object> predicate = predicateFactory.makeObjectPredicate();
        return new BaseVectorValueMatcher(this.selector){
            final VectorMatch match;
            {
                super(selector);
                this.match = VectorMatch.wrap(new int[ObjectVectorValueMatcher.this.selector.getMaxVectorSize()]);
            }

            @Override
            public ReadableVectorMatch match(ReadableVectorMatch mask) {
                Object[] vector = ObjectVectorValueMatcher.this.selector.getObjectVector();
                int[] selection = this.match.getSelection();
                int numRows = 0;
                for (int i = 0; i < mask.getSelectionSize(); ++i) {
                    int rowNum = mask.getSelection()[i];
                    if (!predicate.apply(vector[rowNum])) continue;
                    selection[numRows++] = rowNum;
                }
                this.match.setSelectionSize(numRows);
                assert (this.match.isValid(mask));
                return this.match;
            }
        };
    }
}

