/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import inet.ipaddr.AddressStringException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.ipv4.IPv4Address;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.expression.IPv4AddressExprUtils;

public class IPv4AddressMatchExprMacro
implements ExprMacroTable.ExprMacro {
    public static final String FN_NAME = "ipv4_match";
    private static final int ARG_SUBNET = 1;

    public String name() {
        return FN_NAME;
    }

    public Expr apply(final List<Expr> args) {
        this.validationHelperCheckArgumentCount(args, 2);
        try {
            Expr arg = args.get(0);
            final IPAddressString blockString = this.getSubnetInfo(args);
            final IPAddress block = blockString.toAddress().toPrefixBlock();
            class IPv4AddressMatchExpr
            extends ExprMacroTable.BaseScalarUnivariateMacroFunctionExpr {
                IPv4AddressMatchExpr(Expr arg) {
                    super(IPv4AddressMatchExprMacro.FN_NAME, arg);
                }

                @Nonnull
                public ExprEval eval(Expr.ObjectBinding bindings) {
                    boolean match;
                    ExprEval eval = this.arg.eval(bindings);
                    switch ((ExprType)eval.type().getType()) {
                        case STRING: {
                            match = this.isStringMatch(eval.asString());
                            break;
                        }
                        case LONG: {
                            match = !eval.isNumericNull() && this.isLongMatch(eval.asLong());
                            break;
                        }
                        default: {
                            match = false;
                        }
                    }
                    return ExprEval.ofLongBoolean((boolean)match);
                }

                private boolean isStringMatch(String stringValue) {
                    IPAddressString addressString = IPv4AddressExprUtils.parseString(stringValue);
                    return addressString != null && blockString.prefixContains(addressString);
                }

                private boolean isLongMatch(long longValue) {
                    IPv4Address address = IPv4AddressExprUtils.parse(longValue);
                    return address != null && block.contains((IPAddress)address);
                }

                public Expr visit(Expr.Shuttle shuttle) {
                    return shuttle.visit(IPv4AddressMatchExprMacro.this.apply(shuttle.visitAll(args)));
                }

                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return ExpressionType.LONG;
                }

                public String stringify() {
                    return StringUtils.format((String)"%s(%s, %s)", (Object[])new Object[]{IPv4AddressMatchExprMacro.FN_NAME, this.arg.stringify(), ((Expr)args.get(1)).stringify()});
                }
            }
            return new IPv4AddressMatchExpr(arg);
        }
        catch (AddressStringException e) {
            throw this.processingFailed(e, "failed to parse address", new Object[0]);
        }
    }

    private IPAddressString getSubnetInfo(List<Expr> args) {
        String subnetArgName = "subnet";
        Expr arg = args.get(1);
        this.validationHelperCheckArgIsLiteral(arg, subnetArgName);
        String subnet = (String)arg.getLiteralValue();
        if (!IPv4AddressExprUtils.isValidIPv4Subnet(subnet)) {
            throw this.validationFailed(subnetArgName + " arg has an invalid format: " + subnet, new Object[0]);
        }
        return new IPAddressString(subnet);
    }
}

