/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.dimension;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.dimension.BaseFilteredDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.dimension.ForwardingFilteredDimensionSelector;
import org.apache.druid.query.dimension.PredicateFilteredDimensionSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdMapping;

public class RegexFilteredDimensionSpec
extends BaseFilteredDimensionSpec {
    private static final byte CACHE_TYPE_ID = 2;
    private final String pattern;
    private final Pattern compiledRegex;

    public RegexFilteredDimensionSpec(@JsonProperty(value="delegate") DimensionSpec delegate, @JsonProperty(value="pattern") String pattern) {
        super(delegate);
        this.pattern = (String)Preconditions.checkNotNull((Object)pattern, (Object)"pattern must not be null");
        this.compiledRegex = Pattern.compile(pattern);
    }

    @JsonProperty
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public DimensionSelector decorate(DimensionSelector selector) {
        if (selector == null) {
            return null;
        }
        int selectorCardinality = selector.getValueCardinality();
        if (selectorCardinality < 0 || !selector.nameLookupPossibleInAdvance()) {
            return new PredicateFilteredDimensionSelector(selector, (Predicate<String>)((Predicate)input -> {
                String val = NullHandling.nullToEmptyIfNeeded((String)input);
                return val != null && this.compiledRegex.matcher(val).matches();
            }));
        }
        IdMapping.Builder builder = IdMapping.Builder.ofUnknownCardinality();
        for (int i = 0; i < selectorCardinality; ++i) {
            String val = NullHandling.nullToEmptyIfNeeded((String)selector.lookupName(i));
            if (val == null || !this.compiledRegex.matcher(val).matches()) continue;
            builder.addForwardMapping(i);
        }
        return new ForwardingFilteredDimensionSelector(selector, builder.build());
    }

    public byte[] getCacheKey() {
        byte[] delegateCacheKey = this.delegate.getCacheKey();
        byte[] regexBytes = StringUtils.toUtf8((String)this.pattern);
        return ByteBuffer.allocate(2 + delegateCacheKey.length + regexBytes.length).put((byte)2).put(delegateCacheKey).put((byte)-1).put(regexBytes).array();
    }

    @Override
    public DimensionSpec withDimension(String newDimension) {
        return new RegexFilteredDimensionSpec(this.delegate.withDimension(newDimension), this.pattern);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegexFilteredDimensionSpec that = (RegexFilteredDimensionSpec)o;
        if (!this.delegate.equals(that.delegate)) {
            return false;
        }
        return this.pattern.equals(that.pattern);
    }

    public int hashCode() {
        int result = this.delegate.hashCode();
        result = 31 * result + this.pattern.hashCode();
        return result;
    }

    public String toString() {
        return "RegexFilteredDimensionSpec{pattern='" + this.pattern + '\'' + '}';
    }
}

