/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.dimension;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.BitSet;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.AbstractDimensionSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.DimensionSelectorUtils;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.IdMapping;
import org.apache.druid.segment.data.ArrayBasedIndexedInts;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.filter.BooleanValueMatcher;

final class ForwardingFilteredDimensionSelector
extends AbstractDimensionSelector
implements IdLookup {
    private final DimensionSelector selector;
    private final IdLookup baseIdLookup;
    private final IdMapping idMapping;
    private final ArrayBasedIndexedInts row = new ArrayBasedIndexedInts();

    public ForwardingFilteredDimensionSelector(DimensionSelector selector, IdMapping idMapping) {
        this.selector = (DimensionSelector)Preconditions.checkNotNull((Object)selector);
        if (!selector.nameLookupPossibleInAdvance()) {
            throw new IAE("selector.nameLookupPossibleInAdvance() should return true", new Object[0]);
        }
        this.baseIdLookup = selector.idLookup();
        this.idMapping = (IdMapping)Preconditions.checkNotNull((Object)idMapping);
    }

    @Override
    public IndexedInts getRow() {
        IndexedInts baseRow = this.selector.getRow();
        int baseRowSize = baseRow.size();
        this.row.ensureSize(baseRowSize);
        int resultSize = 0;
        for (int i = 0; i < baseRowSize; ++i) {
            int forwardedValue = this.idMapping.getForwardedId(baseRow.get(i));
            if (forwardedValue < 0) continue;
            this.row.setValue(resultSize, forwardedValue);
            ++resultSize;
        }
        this.row.setSize(resultSize);
        return this.row;
    }

    @Override
    public ValueMatcher makeValueMatcher(final String value) {
        IdLookup idLookup = this.idLookup();
        if (idLookup != null) {
            final int valueId = idLookup.lookupId(value);
            if (valueId >= 0 || value == null) {
                return new ValueMatcher(){

                    @Override
                    public boolean matches() {
                        IndexedInts baseRow = ForwardingFilteredDimensionSelector.this.selector.getRow();
                        int baseRowSize = baseRow.size();
                        boolean nullRow = true;
                        for (int i = 0; i < baseRowSize; ++i) {
                            int forwardedValue = ForwardingFilteredDimensionSelector.this.idMapping.getForwardedId(baseRow.get(i));
                            if (forwardedValue < 0) continue;
                            if (forwardedValue == valueId) {
                                return true;
                            }
                            nullRow = false;
                        }
                        return nullRow && value == null;
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("selector", ForwardingFilteredDimensionSelector.this.selector);
                    }
                };
            }
            return BooleanValueMatcher.of(false);
        }
        return this.makeValueMatcher((Predicate<String>)Predicates.equalTo((Object)value));
    }

    @Override
    public ValueMatcher makeValueMatcher(Predicate<String> predicate) {
        final BitSet valueIds = DimensionSelectorUtils.makePredicateMatchingSet(this, predicate);
        final boolean matchNull = predicate.apply(null);
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                IndexedInts baseRow = ForwardingFilteredDimensionSelector.this.selector.getRow();
                int baseRowSize = baseRow.size();
                boolean nullRow = true;
                for (int i = 0; i < baseRowSize; ++i) {
                    int forwardedValue = ForwardingFilteredDimensionSelector.this.idMapping.getForwardedId(baseRow.get(i));
                    if (forwardedValue < 0) continue;
                    if (valueIds.get(forwardedValue)) {
                        return true;
                    }
                    nullRow = false;
                }
                return nullRow && matchNull;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", ForwardingFilteredDimensionSelector.this.selector);
            }
        };
    }

    @Override
    public int getValueCardinality() {
        return this.idMapping.getValueCardinality();
    }

    @Override
    public String lookupName(int id) {
        return this.selector.lookupName(this.idMapping.getReverseId(id));
    }

    @Override
    public boolean nameLookupPossibleInAdvance() {
        return true;
    }

    @Override
    @Nullable
    public IdLookup idLookup() {
        return this.baseIdLookup != null ? this : null;
    }

    @Override
    public int lookupId(String name) {
        return this.idMapping.getForwardedId(this.baseIdLookup.lookupId(name));
    }

    @Override
    public Class classOfObject() {
        return Object.class;
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("selector", this.selector);
    }
}

