/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.last;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.query.aggregation.last.NumericLastVectorAggregator;
import org.apache.druid.segment.vector.VectorValueSelector;

public class FloatLastVectorAggregator
extends NumericLastVectorAggregator {
    float lastValue = 0.0f;

    public FloatLastVectorAggregator(VectorValueSelector timeSelector, VectorValueSelector valueSelector) {
        super(timeSelector, valueSelector);
    }

    @Override
    void putValue(ByteBuffer buf, int position, int index) {
        this.lastValue = this.valueSelector.getFloatVector()[index];
        buf.putFloat(position, this.lastValue);
    }

    @Override
    public void initValue(ByteBuffer buf, int position) {
        buf.putFloat(position, 0.0f);
    }

    @Override
    @Nullable
    public Object get(ByteBuffer buf, int position) {
        boolean rhsNull = this.isValueNull(buf, position);
        return new SerializablePair((Object)buf.getLong(position), rhsNull ? null : Float.valueOf(buf.getFloat(position + 9)));
    }
}

