/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.QueryException;

public class QueryCapacityExceededException
extends QueryException {
    private static final String TOTAL_ERROR_MESSAGE_TEMPLATE = "Too many concurrent queries, total query capacity of %s exceeded. Please try your query again later.";
    private static final String LANE_ERROR_MESSAGE_TEMPLATE = "Too many concurrent queries for lane '%s', query capacity of %s exceeded. Please try your query again later.";
    private static final String ERROR_CLASS = QueryCapacityExceededException.class.getName();
    public static final String ERROR_CODE = "Query capacity exceeded";
    public static final int STATUS_CODE = 429;

    public QueryCapacityExceededException(int capacity) {
        super(ERROR_CODE, QueryCapacityExceededException.makeTotalErrorMessage(capacity), ERROR_CLASS, null);
    }

    public QueryCapacityExceededException(String lane, int capacity) {
        super(ERROR_CODE, QueryCapacityExceededException.makeLaneErrorMessage(lane, capacity), ERROR_CLASS, null);
    }

    public static QueryCapacityExceededException withErrorMessageAndResolvedHost(String errorMessage) {
        return new QueryCapacityExceededException(ERROR_CODE, errorMessage, ERROR_CLASS, QueryCapacityExceededException.resolveHostname());
    }

    @JsonCreator
    public QueryCapacityExceededException(@JsonProperty(value="error") String errorCode, @JsonProperty(value="errorMessage") String errorMessage, @JsonProperty(value="errorClass") String errorClass, @JsonProperty(value="host") String host) {
        super(errorCode, errorMessage, errorClass, host);
    }

    @VisibleForTesting
    public static String makeTotalErrorMessage(int capacity) {
        return StringUtils.format((String)TOTAL_ERROR_MESSAGE_TEMPLATE, (Object[])new Object[]{capacity});
    }

    @VisibleForTesting
    public static String makeLaneErrorMessage(String lane, int capacity) {
        return StringUtils.format((String)LANE_ERROR_MESSAGE_TEMPLATE, (Object[])new Object[]{lane, capacity});
    }
}

