/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write.columnar;

import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.allocation.AppendableMemory;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.allocation.MemoryRange;
import org.apache.druid.frame.write.columnar.FrameColumnWriter;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.serde.ComplexMetricSerde;

public class ComplexFrameColumnWriter
implements FrameColumnWriter {
    private static final int INITIAL_ALLOCATION_SIZE = 128;
    public static final byte NOT_NULL_MARKER = 0;
    public static final byte NULL_MARKER = 1;
    public static final int TYPE_NAME_LENGTH_POSITION = 1;
    public static final int TYPE_NAME_POSITION = 5;
    private final ComplexMetricSerde serde;
    private final BaseObjectColumnValueSelector<?> selector;
    private final AppendableMemory offsetMemory;
    private final AppendableMemory dataMemory;
    private final byte[] typeNameBytes;
    private int lastDataLength = -1;

    ComplexFrameColumnWriter(BaseObjectColumnValueSelector<?> selector, MemoryAllocator allocator, ComplexMetricSerde serde) {
        this.selector = selector;
        this.serde = serde;
        this.offsetMemory = AppendableMemory.create(allocator, 128);
        this.dataMemory = AppendableMemory.create(allocator, 128);
        this.typeNameBytes = StringUtils.toUtf8((String)serde.getTypeName());
    }

    @Override
    public boolean addSelection() {
        byte[] complexBytes;
        if (!this.offsetMemory.reserveAdditional(4)) {
            return false;
        }
        Object complexObject = this.selector.getObject();
        byte[] byArray = complexBytes = complexObject == null ? ByteArrays.EMPTY_ARRAY : this.serde.toBytes(complexObject);
        if (complexBytes.length == Integer.MAX_VALUE) {
            return false;
        }
        int dataLength = complexBytes.length + 1;
        if (this.dataMemory.size() + (long)dataLength > Integer.MAX_VALUE || !this.dataMemory.reserveAdditional(dataLength)) {
            return false;
        }
        MemoryRange<WritableMemory> offsetCursor = this.offsetMemory.cursor();
        offsetCursor.memory().putInt(offsetCursor.start(), Ints.checkedCast((long)(this.dataMemory.size() + (long)dataLength)));
        this.offsetMemory.advanceCursor(4);
        MemoryRange<WritableMemory> dataCursor = this.dataMemory.cursor();
        dataCursor.memory().putByte(dataCursor.start(), complexObject == null ? (byte)1 : 0);
        dataCursor.memory().putByteArray(dataCursor.start() + 1L, complexBytes, 0, complexBytes.length);
        this.dataMemory.advanceCursor(dataLength);
        this.lastDataLength = dataLength;
        return true;
    }

    @Override
    public void undo() {
        if (this.lastDataLength == -1) {
            throw new ISE("Nothing to undo", new Object[0]);
        }
        this.offsetMemory.rewindCursor(4);
        this.dataMemory.rewindCursor(this.lastDataLength);
        this.lastDataLength = -1;
    }

    @Override
    public long size() {
        return (long)this.headerSize() + this.offsetMemory.size() + this.dataMemory.size();
    }

    @Override
    public long writeTo(WritableMemory memory, long startPosition) {
        long currentPosition = startPosition;
        memory.putByte(currentPosition, (byte)5);
        memory.putInt(++currentPosition, this.typeNameBytes.length);
        memory.putByteArray(currentPosition += 4L, this.typeNameBytes, 0, this.typeNameBytes.length);
        currentPosition += (long)this.typeNameBytes.length;
        currentPosition += this.offsetMemory.writeTo(memory, currentPosition);
        currentPosition += this.dataMemory.writeTo(memory, currentPosition);
        return currentPosition - startPosition;
    }

    @Override
    public void close() {
        this.offsetMemory.close();
        this.dataMemory.close();
    }

    private int headerSize() {
        return 5 + this.typeNameBytes.length;
    }
}

