/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.write;

import java.util.Arrays;
import java.util.List;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.key.FrameComparisonWidget;
import org.apache.druid.frame.key.SortColumn;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.java.util.common.ISE;

public class FrameSort {
    private FrameSort() {
    }

    public static void sort(Frame frame, FrameReader frameReader, List<SortColumn> sortColumns) {
        int i;
        if (!frame.isPermuted()) {
            throw new ISE("Cannot sort nonpermuted frame", new Object[0]);
        }
        if (sortColumns.isEmpty()) {
            throw new ISE("Cannot sort with an empty column list", new Object[0]);
        }
        WritableMemory memory = frame.writableMemory();
        Integer[] rows = new Integer[frame.numRows()];
        for (int i2 = 0; i2 < frame.numRows(); ++i2) {
            rows[i2] = i2;
        }
        FrameComparisonWidget comparisonWidget1 = frameReader.makeComparisonWidget(frame, sortColumns);
        FrameComparisonWidget comparisonWidget2 = frameReader.makeComparisonWidget(frame, sortColumns);
        Arrays.sort(rows, (k1, k2) -> comparisonWidget1.compare((int)k1, comparisonWidget2, (int)k2));
        for (i = 0; i < frame.numRows(); ++i) {
            rows[i] = frame.physicalRow(rows[i]);
        }
        for (i = 0; i < frame.numRows(); ++i) {
            memory.putInt(18L + (long)i * 4L, rows[i].intValue());
        }
    }
}

