/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.segment.columnar;

import java.io.IOException;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorCursor;
import org.apache.druid.segment.vector.VectorOffset;

public class FrameVectorCursor
implements VectorCursor {
    private final VectorOffset offset;
    private final VectorColumnSelectorFactory columnSelectorFactory;
    private final Closer closer;

    FrameVectorCursor(VectorOffset offset, VectorColumnSelectorFactory columnSelectorFactory, Closer closer) {
        this.offset = offset;
        this.columnSelectorFactory = columnSelectorFactory;
        this.closer = closer;
    }

    @Override
    public VectorColumnSelectorFactory getColumnSelectorFactory() {
        return this.columnSelectorFactory;
    }

    @Override
    public void advance() {
        this.offset.advance();
        BaseQuery.checkInterrupted();
    }

    @Override
    public boolean isDone() {
        return this.offset.isDone();
    }

    @Override
    public void reset() {
        this.offset.reset();
    }

    @Override
    public void close() {
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getMaxVectorSize() {
        return this.offset.getMaxVectorSize();
    }

    @Override
    public int getCurrentVectorSize() {
        return this.offset.getCurrentVectorSize();
    }
}

