/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import it.unimi.dsi.fastutil.ints.IntHeapPriorityQueue;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntPriorityQueue;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.FrameWithPartition;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.frame.key.FrameComparisonWidget;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.FrameRowTooLargeException;
import org.apache.druid.frame.processor.MultiColumnSelectorFactory;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;

public class FrameChannelMerger
implements FrameProcessor<Long> {
    private static final long UNLIMITED = -1L;
    private final List<ReadableFrameChannel> inputChannels;
    private final WritableFrameChannel outputChannel;
    private final FrameReader frameReader;
    private final ClusterBy clusterBy;
    private final ClusterByPartitions partitions;
    private final IntPriorityQueue priorityQueue;
    private final FrameWriterFactory frameWriterFactory;
    private final FramePlus[] currentFrames;
    private final long rowLimit;
    private long rowsOutput = 0L;
    private int currentPartition = 0;
    final MultiColumnSelectorFactory mergedColumnSelectorFactory;

    public FrameChannelMerger(List<ReadableFrameChannel> inputChannels, FrameReader frameReader, WritableFrameChannel outputChannel, FrameWriterFactory frameWriterFactory, ClusterBy clusterBy, @Nullable ClusterByPartitions partitions, long rowLimit) {
        ClusterByPartitions partitionsToUse;
        if (inputChannels.isEmpty()) {
            throw new IAE("Must have at least one input channel", new Object[0]);
        }
        ClusterByPartitions clusterByPartitions = partitionsToUse = partitions == null ? ClusterByPartitions.oneUniversalPartition() : partitions;
        if (!partitionsToUse.allAbutting()) {
            throw new IAE("Partitions must all abut each other", new Object[0]);
        }
        this.inputChannels = inputChannels;
        this.outputChannel = outputChannel;
        this.frameReader = frameReader;
        this.frameWriterFactory = frameWriterFactory;
        this.clusterBy = clusterBy;
        this.partitions = partitionsToUse;
        this.rowLimit = rowLimit;
        this.currentFrames = new FramePlus[inputChannels.size()];
        this.priorityQueue = new IntHeapPriorityQueue(inputChannels.size(), (k1, k2) -> this.currentFrames[k1].comparisonWidget.compare(this.currentFrames[k1].rowNumber, this.currentFrames[k2].comparisonWidget, this.currentFrames[k2].rowNumber));
        ArrayList<Supplier<ColumnSelectorFactory>> frameColumnSelectorFactorySuppliers = new ArrayList<Supplier<ColumnSelectorFactory>>(inputChannels.size());
        int i = 0;
        while (i < inputChannels.size()) {
            int frameNumber = i++;
            frameColumnSelectorFactorySuppliers.add(() -> this.currentFrames[frameNumber].cursor.getColumnSelectorFactory());
        }
        this.mergedColumnSelectorFactory = new MultiColumnSelectorFactory(frameColumnSelectorFactorySuppliers, RowSignature.builder().addAll(frameReader.signature()).add("___druid_frame_row_signature", ColumnType.UNKNOWN_COMPLEX).add("___druid_frame_row_mem", ColumnType.UNKNOWN_COMPLEX).build());
    }

    @Override
    public List<ReadableFrameChannel> inputChannels() {
        return this.inputChannels;
    }

    @Override
    public List<WritableFrameChannel> outputChannels() {
        return Collections.singletonList(this.outputChannel);
    }

    @Override
    public ReturnOrAwait<Long> runIncrementally(IntSet readableInputs) throws IOException {
        IntSet awaitSet = this.populateCurrentFramesAndPriorityQueue();
        if (!awaitSet.isEmpty()) {
            return ReturnOrAwait.awaitAll(awaitSet);
        }
        if (this.priorityQueue.isEmpty()) {
            return ReturnOrAwait.returnObject(this.rowsOutput);
        }
        this.outputChannel.write(this.nextFrame());
        return ReturnOrAwait.runAgain();
    }

    private FrameWithPartition nextFrame() {
        if (this.priorityQueue.isEmpty()) {
            throw new NoSuchElementException();
        }
        try (FrameWriter mergedFrameWriter = this.frameWriterFactory.newFrameWriter(this.mergedColumnSelectorFactory);){
            int mergedFramePartition = this.currentPartition;
            RowKey currentPartitionEnd = this.partitions.get(this.currentPartition).getEnd();
            while (!this.priorityQueue.isEmpty()) {
                FramePlus currentFrame;
                int currentChannel = this.priorityQueue.firstInt();
                this.mergedColumnSelectorFactory.setCurrentFactory(currentChannel);
                if (currentPartitionEnd != null && (currentFrame = this.currentFrames[currentChannel]).comparisonWidget.compare(currentFrame.rowNumber, currentPartitionEnd) >= 0) {
                    do {
                        ++this.currentPartition;
                    } while ((currentPartitionEnd = this.partitions.get(this.currentPartition).getEnd()) != null && currentFrame.comparisonWidget.compare(currentFrame.rowNumber, currentPartitionEnd) >= 0);
                    if (mergedFrameWriter.getNumRows() != 0) break;
                    mergedFramePartition = this.currentPartition;
                }
                if (mergedFrameWriter.addSelection()) {
                    ++this.rowsOutput;
                } else {
                    if (mergedFrameWriter.getNumRows() != 0) break;
                    throw new FrameRowTooLargeException(this.frameWriterFactory.allocatorCapacity());
                }
                if (this.rowLimit != -1L && this.rowsOutput >= this.rowLimit) {
                    this.priorityQueue.clear();
                    Arrays.fill(this.currentFrames, null);
                    continue;
                }
                if (currentChannel != this.priorityQueue.dequeueInt()) {
                    throw new ISE("Unexpected channel", new Object[0]);
                }
                FramePlus channelFramePlus = this.currentFrames[currentChannel];
                channelFramePlus.advance();
                if (!channelFramePlus.cursor.isDone()) {
                    this.priorityQueue.enqueue(currentChannel);
                    continue;
                }
                this.currentFrames[currentChannel] = null;
                ReadableFrameChannel channel = this.inputChannels.get(currentChannel);
                if (channel.canRead()) {
                    Frame frame = channel.read();
                    this.currentFrames[currentChannel] = new FramePlus(frame, this.frameReader, this.clusterBy);
                    this.priorityQueue.enqueue(currentChannel);
                    continue;
                }
                if (channel.isFinished()) continue;
            }
            Frame nextFrame = Frame.wrap(mergedFrameWriter.toByteArray());
            FrameWithPartition frameWithPartition = new FrameWithPartition(nextFrame, mergedFramePartition);
            return frameWithPartition;
        }
    }

    @Override
    public void cleanup() throws IOException {
        FrameProcessors.closeAll(this.inputChannels(), this.outputChannels(), new Closeable[0]);
    }

    private IntSet populateCurrentFramesAndPriorityQueue() {
        IntOpenHashSet await = new IntOpenHashSet();
        for (int i = 0; i < this.inputChannels.size(); ++i) {
            if (this.currentFrames[i] != null) continue;
            ReadableFrameChannel channel = this.inputChannels.get(i);
            if (channel.canRead()) {
                Frame frame = channel.read();
                this.currentFrames[i] = new FramePlus(frame, this.frameReader, this.clusterBy);
                this.priorityQueue.enqueue(i);
                continue;
            }
            if (channel.isFinished()) continue;
            await.add(i);
        }
        return await;
    }

    private static class FramePlus {
        private final Cursor cursor;
        private final FrameComparisonWidget comparisonWidget;
        private int rowNumber;

        private FramePlus(Frame frame, FrameReader frameReader, ClusterBy clusterBy) {
            this.cursor = FrameProcessors.makeCursor(frame, frameReader);
            this.comparisonWidget = frameReader.makeComparisonWidget(frame, clusterBy.getColumns());
            this.rowNumber = 0;
        }

        private void advance() {
            this.cursor.advance();
            ++this.rowNumber;
        }
    }
}

