/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;

public class SortColumn {
    private final String columnName;
    private final boolean descending;

    @JsonCreator
    public SortColumn(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="descending") boolean descending) {
        if (columnName == null || columnName.isEmpty()) {
            throw new IAE("Cannot have null or empty column name", new Object[0]);
        }
        this.columnName = columnName;
        this.descending = descending;
    }

    @JsonProperty
    public String columnName() {
        return this.columnName;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean descending() {
        return this.descending;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortColumn that = (SortColumn)o;
        return this.descending == that.descending && Objects.equals(this.columnName, that.columnName);
    }

    public int hashCode() {
        return Objects.hash(this.columnName, this.descending);
    }

    public String toString() {
        return StringUtils.format((String)"%s%s", (Object[])new Object[]{this.columnName, this.descending ? " DESC" : ""});
    }
}

