/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.hash.Hashing;
import java.util.Arrays;

public class RowKey {
    private static final RowKey EMPTY_KEY = new RowKey(new byte[0]);
    private final byte[] key;
    private volatile long hashCode;
    private volatile boolean hashCodeComputed;

    private RowKey(byte[] key) {
        this.key = key;
    }

    @JsonCreator
    public static RowKey wrap(byte[] row) {
        if (row.length == 0) {
            return EMPTY_KEY;
        }
        return new RowKey(row);
    }

    public static RowKey empty() {
        return EMPTY_KEY;
    }

    @JsonValue
    public byte[] array() {
        return this.key;
    }

    public long longHashCode() {
        if (!this.hashCodeComputed) {
            this.hashCode = Hashing.murmur3_128().hashBytes(this.key).asLong();
            this.hashCodeComputed = true;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowKey that = (RowKey)o;
        return Arrays.equals(this.key, that.key);
    }

    public int hashCode() {
        return (int)this.longHashCode();
    }

    public String toString() {
        return Arrays.toString(this.key);
    }
}

