/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server.interceptor;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import java.util.Collection;
import org.apache.cxf.transport.http.netty.server.interceptor.NettyInterceptor;
import org.apache.cxf.transport.http.netty.server.servlet.HttpSessionThreadLocal;
import org.apache.cxf.transport.http.netty.server.servlet.NettyHttpSession;
import org.apache.cxf.transport.http.netty.server.session.HttpSessionStore;
import org.apache.cxf.transport.http.netty.server.util.Utils;

public class HttpSessionInterceptor
implements NettyInterceptor {
    private boolean sessionRequestedByCookie;

    public HttpSessionInterceptor(HttpSessionStore sessionStore) {
        HttpSessionThreadLocal.setSessionStore(sessionStore);
    }

    @Override
    public void onRequestReceived(ChannelHandlerContext ctx, HttpRequest request) {
        HttpSessionThreadLocal.unset();
        Collection<Cookie> cookies = Utils.getCookies("JSESSIONID", request);
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String jsessionId = cookie.value();
                NettyHttpSession s = HttpSessionThreadLocal.getSessionStore().findSession(jsessionId);
                if (s == null) continue;
                HttpSessionThreadLocal.set(s);
                this.sessionRequestedByCookie = true;
                break;
            }
        }
    }

    @Override
    public void onRequestSuccessed(ChannelHandlerContext ctx, HttpResponse response) {
        NettyHttpSession s = HttpSessionThreadLocal.get();
        if (s != null && !this.sessionRequestedByCookie) {
            HttpHeaders.addHeader((HttpMessage)response, (String)"Set-Cookie", (Object)ClientCookieEncoder.STRICT.encode("JSESSIONID", s.getId()));
        }
    }

    @Override
    public void onRequestFailed(ChannelHandlerContext ctx, Throwable e) {
        this.sessionRequestedByCookie = false;
        HttpSessionThreadLocal.unset();
    }
}

