/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server.servlet;

import io.netty.handler.codec.http.ClientCookieEncoder;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.transport.http.netty.server.servlet.NettyServletOutputStream;

public class NettyServletResponse
implements HttpServletResponse {
    private HttpResponse originalResponse;
    private NettyServletOutputStream outputStream;
    private PrintWriter writer;
    private boolean responseCommited;

    public NettyServletResponse(HttpResponse response) {
        this.originalResponse = response;
        this.outputStream = new NettyServletOutputStream((HttpContent)response);
        this.writer = new PrintWriter((OutputStream)((Object)this.outputStream));
    }

    public HttpResponse getOriginalResponse() {
        return this.originalResponse;
    }

    public void addCookie(Cookie cookie) {
        HttpHeaders.addHeader((HttpMessage)this.originalResponse, (String)"Set-Cookie", (Object)ClientCookieEncoder.encode((String)cookie.getName(), (String)cookie.getValue()));
    }

    public void addDateHeader(String name, long date) {
        HttpHeaders.addHeader((HttpMessage)this.originalResponse, (String)name, (Object)date);
    }

    public void addHeader(String name, String value) {
        HttpHeaders.addHeader((HttpMessage)this.originalResponse, (String)name, (Object)value);
    }

    public void addIntHeader(String name, int value) {
        HttpHeaders.addIntHeader((HttpMessage)this.originalResponse, (String)name, (int)value);
    }

    public void addCookie(javax.servlet.http.Cookie cookie) {
    }

    public boolean containsHeader(String name) {
        return this.originalResponse.headers().contains(name);
    }

    public void sendError(int sc) throws IOException {
        this.originalResponse.setStatus(HttpResponseStatus.valueOf((int)sc));
    }

    public void sendError(int sc, String msg) throws IOException {
        this.originalResponse.setStatus(new HttpResponseStatus(sc, msg));
    }

    public void sendRedirect(String location) throws IOException {
        this.setStatus(302);
        this.setHeader("Location", location);
    }

    public void setDateHeader(String name, long date) {
        HttpHeaders.setHeader((HttpMessage)this.originalResponse, (String)name, (Object)date);
    }

    public void setHeader(String name, String value) {
        HttpHeaders.setHeader((HttpMessage)this.originalResponse, (String)name, (Object)value);
    }

    public void setIntHeader(String name, int value) {
        HttpHeaders.setIntHeader((HttpMessage)this.originalResponse, (String)name, (int)value);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        return this.writer;
    }

    public void setStatus(int sc) {
        this.originalResponse.setStatus(HttpResponseStatus.valueOf((int)sc));
    }

    public void setStatus(int sc, String sm) {
        this.originalResponse.setStatus(new HttpResponseStatus(sc, sm));
    }

    public void setContentType(String type) {
        HttpHeaders.setHeader((HttpMessage)this.originalResponse, (String)"Content-Type", (Object)type);
    }

    public void setContentLength(int len) {
        HttpHeaders.setContentLength((HttpMessage)this.originalResponse, (long)len);
    }

    public boolean isCommitted() {
        return this.responseCommited;
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response already commited!");
        }
        this.originalResponse.headers().clear();
        this.resetBuffer();
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response already commited!");
        }
        this.outputStream.resetBuffer();
    }

    public void flushBuffer() throws IOException {
        this.getWriter().flush();
        this.responseCommited = true;
    }

    public int getBufferSize() {
        return this.outputStream.getBufferSize();
    }

    public void setBufferSize(int size) {
    }

    public String encodeRedirectURL(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeURL(String url) {
        try {
            return URLEncoder.encode(url, this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error encoding url!", e);
        }
    }

    public String encodeUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String getCharacterEncoding() {
        throw new IllegalStateException("Method 'getCharacterEncoding' not yet implemented!");
    }

    public String getContentType() {
        throw new IllegalStateException("Method 'getContentType' not yet implemented!");
    }

    public Locale getLocale() {
        throw new IllegalStateException("Method 'getLocale' not yet implemented!");
    }

    public void setCharacterEncoding(String charset) {
        throw new IllegalStateException("Method 'setCharacterEncoding' not yet implemented!");
    }

    public void setLocale(Locale loc) {
        throw new IllegalStateException("Method 'setLocale' not yet implemented!");
    }
}

