/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.validator;

import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.common.config.WSDLValidatorElement;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointDescriptionJava;
import org.apache.axis2.jaxws.description.EndpointDescriptionWSDL;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.impl.DescriptionUtils;
import org.apache.axis2.jaxws.description.validator.EndpointInterfaceDescriptionValidator;
import org.apache.axis2.jaxws.description.validator.Validator;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.util.WSDLExtensionValidatorUtil;

public class EndpointDescriptionValidator
extends Validator {
    EndpointDescription endpointDesc;
    EndpointDescriptionJava endpointDescJava;
    EndpointDescriptionWSDL endpointDescWSDL;

    public EndpointDescriptionValidator(EndpointDescription toValidate) {
        this.endpointDesc = toValidate;
        this.endpointDescJava = (EndpointDescriptionJava)((Object)this.endpointDesc);
        this.endpointDescWSDL = (EndpointDescriptionWSDL)((Object)this.endpointDesc);
    }

    @Override
    public boolean validate(boolean performValidation) {
        if (this.getValidationLevel() == Validator.ValidationLevel.OFF) {
            return true;
        }
        if (this.endpointDesc.getServiceDescription().isServerSide()) {
            if (!this.validateWSDLPort()) {
                return false;
            }
            if (!this.validateWSDLBindingType()) {
                return false;
            }
        }
        if (!this.validateRespectBinding(performValidation)) {
            return false;
        }
        return this.validateEndpointInterface();
    }

    @Override
    public boolean validate() {
        return this.validate(false);
    }

    private boolean validateWSDLBindingType() {
        boolean isBindingValid = false;
        String bindingType = this.endpointDesc.getBindingType();
        String wsdlBindingType = this.endpointDescWSDL.getWSDLBindingType();
        if (bindingType == null) {
            this.addValidationFailure(this, "Annotation binding type is null and did not have a default");
            isBindingValid = false;
        } else if (!("http://schemas.xmlsoap.org/wsdl/soap/http".equals(bindingType) || "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(bindingType) || "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(bindingType) || "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(bindingType) || "http://www.w3.org/2010/soapjms/".equals(bindingType) || "http://www.w3.org/2010/soapjms/?mtom=true".equals(bindingType) || "http://www.w3.org/2010/soapjms/".equals(bindingType) || "http://www.w3.org/2010/soapjms/?mtom=true".equals(bindingType) || "http://www.w3.org/2004/08/wsdl/http".equals(bindingType) || "SOAP_HTTP_BINDING".equals(bindingType))) {
            this.addValidationFailure(this, "Invalid annotation binding value specified: " + bindingType);
            isBindingValid = false;
        } else if (bindingType.equals("SOAP_HTTP_BINDING") && this.endpointDesc.isEndpointBased()) {
            this.addValidationFailure(this, "A SOAP_HTTP_BINDING was found on a @Bindingtype SEI based Endpoint. SOAP_HTTP_BINDING is supported on Provider Endpoints only.");
            isBindingValid = false;
        } else if (wsdlBindingType == null) {
            isBindingValid = true;
        } else if (!("http://schemas.xmlsoap.org/wsdl/soap/http".equals(wsdlBindingType) || "http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(wsdlBindingType) || "http://www.w3.org/2004/08/wsdl/http".equals(wsdlBindingType) || "http://www.w3.org/2010/soapjms/".equals(wsdlBindingType) || "http://www.w3.org/2010/soapjms/".equals(wsdlBindingType))) {
            this.addValidationFailure(this, "Invalid wsdl binding value specified: " + DescriptionUtils.mapBindingTypeAnnotationToWsdl(wsdlBindingType));
            isBindingValid = false;
        } else if (wsdlBindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http") && (bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http") || bindingType.equals("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true"))) {
            isBindingValid = true;
        } else if (wsdlBindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") && (bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || bindingType.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true"))) {
            isBindingValid = true;
        } else if (wsdlBindingType.equals("http://www.w3.org/2004/08/wsdl/http") && bindingType.equals("http://www.w3.org/2004/08/wsdl/http")) {
            isBindingValid = true;
        } else if (wsdlBindingType.equals("http://www.w3.org/2010/soapjms/") && bindingType.startsWith("http://www.w3.org/2010/soapjms/")) {
            isBindingValid = true;
        } else if (wsdlBindingType.equals("http://www.w3.org/2010/soapjms/") && bindingType.startsWith("http://www.w3.org/2010/soapjms/")) {
            isBindingValid = true;
        } else if (wsdlBindingType.equals("http://www.w3.org/2004/08/wsdl/http") && this.endpointDesc.isEndpointBased()) {
            this.addValidationFailure(this, "An HTTPBinding was found on an @WebService SEI based endpoint. This is not supported.  An HTTPBinding must use an @WebServiceProvider endpoint.");
            isBindingValid = false;
        } else if (!wsdlBindingType.equals("http://www.w3.org/2004/08/wsdl/http") && bindingType.equals("SOAP_HTTP_BINDING") && this.endpointDesc.isProviderBased()) {
            isBindingValid = true;
        } else {
            String wsdlInsert = "[" + EndpointDescriptionValidator.bindingHumanReadableDescription(wsdlBindingType) + "]namespace = {" + DescriptionUtils.mapBindingTypeAnnotationToWsdl(wsdlBindingType) + "}";
            String annotationInsert = "[" + EndpointDescriptionValidator.bindingHumanReadableDescription(bindingType) + "]namespace = {" + bindingType + "}";
            String message = Messages.getMessage("endpointDescriptionValidation", wsdlInsert, annotationInsert);
            this.addValidationFailure(this, message);
            isBindingValid = false;
        }
        return isBindingValid;
    }

    private boolean validateWSDLPort() {
        Port wsdlPort;
        Service wsdlService = this.endpointDescWSDL.getWSDLService();
        if (wsdlService != null && (wsdlPort = this.endpointDescWSDL.getWSDLPort()) == null) {
            this.addValidationFailure(this, "Serivce exists in WSDL, but Port does not.  Not a valid Partial WSDL.  Service: " + this.endpointDesc.getServiceQName() + "; Port: " + this.endpointDesc.getPortQName());
            return false;
        }
        return true;
    }

    private boolean validateEndpointInterface() {
        EndpointInterfaceDescriptionValidator eidValidator;
        boolean isEndpointInterfaceValid;
        EndpointInterfaceDescription eid = this.endpointDesc.getEndpointInterfaceDescription();
        if (eid != null && !(isEndpointInterfaceValid = (eidValidator = new EndpointInterfaceDescriptionValidator(eid)).validate())) {
            this.addValidationFailure(eidValidator, "Invalid Endpoint Interface");
            return false;
        }
        return true;
    }

    private boolean validateRespectBinding(boolean performValidation) {
        if (!performValidation) {
            return true;
        }
        if (this.endpointDesc.respectBinding()) {
            WSDLValidatorElement[] elements;
            String wsdlLocation = null;
            if (this.endpointDesc.getServiceDescription().isServerSide() && ((wsdlLocation = !this.endpointDesc.isProviderBased() ? this.endpointDescJava.getAnnoWebServiceWSDLLocation() : this.endpointDescJava.getAnnoWebServiceProvider().wsdlLocation()) == null || wsdlLocation.length() == 0)) {
                this.addValidationFailure(this, "Annotation @RespectBinding requires that a WSDL file be specified.");
                return false;
            }
            Set<WSDLValidatorElement> extensionSet = this.endpointDesc.getRequiredBindings();
            Definition wsdlDefinition = this.endpointDescWSDL.getWSDLDefinition();
            AxisConfiguration axisConfiguration = this.endpointDesc.getServiceDescription().getAxisConfigContext().getAxisConfiguration();
            WSDLExtensionValidatorUtil.performValidation(axisConfiguration, extensionSet, wsdlDefinition, this.endpointDesc);
            for (WSDLValidatorElement element : elements = extensionSet.toArray(new WSDLValidatorElement[0])) {
                WSDLValidatorElement.State state = element.getState();
                if (state == WSDLValidatorElement.State.NOT_SUPPORTED) {
                    QName type = element.getExtensionElement().getElementType();
                    this.addValidationFailure(this, "Annotation @RespectBinding was enabled, but the Extension Element " + type + " is not supported.");
                    return false;
                }
                if (state == WSDLValidatorElement.State.NOT_RECOGNIZED) {
                    QName type = element.getExtensionElement().getElementType();
                    this.addValidationFailure(this, "Annotation @RespectBinding was enabled, but the Extension Element " + type + " is not Recognized.");
                    return false;
                }
                if (state != WSDLValidatorElement.State.ERROR) continue;
                QName type = element.getExtensionElement().getElementType();
                this.addValidationFailure(this, "Annotation @RespectBinding was enabled, but following Error occured while processing the Extension Element " + type + " " + element.getErrorMessage());
                return false;
            }
        }
        return true;
    }

    private static String bindingHumanReadableDescription(String ns) {
        if ("http://schemas.xmlsoap.org/wsdl/soap/http".equals(ns)) {
            return "SOAP 1.1 HTTP Binding";
        }
        if ("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".equals(ns)) {
            return "SOAP 1.1 MTOM HTTP Binding";
        }
        if ("http://www.w3.org/2003/05/soap/bindings/HTTP/".equals(ns)) {
            return "SOAP 1.2 HTTP Binding";
        }
        if ("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".equals(ns)) {
            return "SOAP 1.2 MTOM HTTP Binding";
        }
        if ("http://www.w3.org/2010/soapjms/".equals(ns)) {
            return "SOAP 1.1 JMS Binding";
        }
        if ("http://www.w3.org/2010/soapjms/?mtom=true".equals(ns)) {
            return "SOAP 1.1 MTOM JMS Binding";
        }
        if ("http://www.w3.org/2010/soapjms/".equals(ns)) {
            return "SOAP 1.2 JMS Binding";
        }
        if ("http://www.w3.org/2010/soapjms/?mtom=true".equals(ns)) {
            return "SOAP 1.2 MTOM JMS Binding";
        }
        if ("http://www.w3.org/2004/08/wsdl/http".equals(ns)) {
            return "XML HTTP Binding";
        }
        return "Unknown Binding";
    }
}

