/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axis2.util.CommandLineOption;
import org.apache.axis2.util.CommandLineOptionConstants;
import org.apache.axis2.util.OptionsValidator;

public class CommandLineOptionParser
implements CommandLineOptionConstants {
    private static int STARTED = 0;
    private static int NEW_OPTION = 1;
    private static int SUB_PARAM_OF_OPTION = 2;
    private Map commandLineOptions;

    public CommandLineOptionParser(Map commandLineOptions) {
        this.commandLineOptions = commandLineOptions;
    }

    public CommandLineOptionParser(String[] args) {
        this.commandLineOptions = this.parse(args);
    }

    private Map parse(String[] args) {
        CommandLineOption commandLineOption;
        HashMap<String, CommandLineOption> commandLineOptions = new HashMap<String, CommandLineOption>();
        if (0 == args.length) {
            return commandLineOptions;
        }
        int state = STARTED;
        ArrayList<String> optionBundle = null;
        String optionType = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (STARTED == state) {
                    state = NEW_OPTION;
                    optionType = args[i];
                    continue;
                }
                if (SUB_PARAM_OF_OPTION != state && NEW_OPTION != state) continue;
                commandLineOption = new CommandLineOption(optionType, optionBundle);
                commandLineOptions.put(commandLineOption.getOptionType(), commandLineOption);
                state = NEW_OPTION;
                optionType = args[i];
                optionBundle = null;
                continue;
            }
            if (STARTED == state) {
                commandLineOption = new CommandLineOption("SOLE_INPUT", args);
                commandLineOptions.put(commandLineOption.getOptionType(), commandLineOption);
                return commandLineOptions;
            }
            if (NEW_OPTION == state) {
                optionBundle = new ArrayList<String>();
                optionBundle.add(args[i]);
                state = SUB_PARAM_OF_OPTION;
                continue;
            }
            if (SUB_PARAM_OF_OPTION != state) continue;
            optionBundle.add(args[i]);
        }
        commandLineOption = new CommandLineOption(optionType, optionBundle);
        commandLineOptions.put(commandLineOption.getOptionType(), commandLineOption);
        return commandLineOptions;
    }

    public Map getAllOptions() {
        return this.commandLineOptions;
    }

    public List getInvalidOptions(OptionsValidator validator) {
        ArrayList<CommandLineOption> faultList = new ArrayList<CommandLineOption>();
        Iterator iterator = this.commandLineOptions.values().iterator();
        while (iterator.hasNext()) {
            CommandLineOption commandLineOption = (CommandLineOption)iterator.next();
            if (!validator.isInvalid(commandLineOption)) continue;
            faultList.add(commandLineOption);
        }
        return faultList;
    }
}

