/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.nhttp;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpCoreRequestResponseTransport
implements RequestResponseTransport {
    private static final Log log = LogFactory.getLog((Class)HttpCoreRequestResponseTransport.class);
    private RequestResponseTransport.RequestResponseTransportStatus status = RequestResponseTransport.RequestResponseTransportStatus.INITIAL;
    private MessageContext msgContext = null;
    private boolean responseWritten = false;

    HttpCoreRequestResponseTransport(MessageContext msgContext) {
        this.msgContext = msgContext;
    }

    public void acknowledgeMessage(MessageContext msgContext) throws AxisFault {
        log.debug((Object)"Acking one-way request");
        this.status = RequestResponseTransport.RequestResponseTransportStatus.ACKED;
    }

    public void awaitResponse() throws InterruptedException, AxisFault {
        log.debug((Object)"Returning thread but keeping socket open -- awaiting response");
        this.status = RequestResponseTransport.RequestResponseTransportStatus.WAITING;
        this.msgContext.getOperationContext().setProperty("RESPONSE_WRITTEN", "SKIP");
    }

    public void signalResponseReady() {
        log.debug((Object)"Signal response available");
        this.status = RequestResponseTransport.RequestResponseTransportStatus.SIGNALLED;
    }

    public RequestResponseTransport.RequestResponseTransportStatus getStatus() {
        return this.status;
    }

    public void signalFaultReady(AxisFault fault) {
    }

    public boolean isResponseWritten() {
        return this.responseWritten;
    }

    public void setResponseWritten(boolean responseWritten) {
        this.responseWritten = responseWritten;
    }
}

