/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.deployment.AxisConfigBuilder;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.FileSystemConfigurator;
import org.apache.axis2.deployment.URLBasedAxisConfigurator;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisConfigurator;
import org.apache.axis2.engine.DependencyManager;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.modules.Module;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.util.Loader;
import org.apache.axis2.util.SessionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationContextFactory {
    protected static final Log log = LogFactory.getLog((Class)ConfigurationContextFactory.class);

    public static ConfigurationContext createConfigurationContext(AxisConfigurator axisConfigurator) throws AxisFault {
        AxisConfiguration axisConfig = axisConfigurator.getAxisConfiguration();
        ConfigurationContext configContext = new ConfigurationContext(axisConfig);
        if (axisConfig.getClusterManager() != null) {
            configContext.initCluster();
        }
        if (axisConfigurator instanceof DeploymentEngine) {
            ((DeploymentEngine)((Object)axisConfigurator)).setConfigContext(configContext);
        }
        ConfigurationContextFactory.setContextPaths(axisConfig, configContext);
        ConfigurationContextFactory.init(configContext);
        axisConfigurator.engageGlobalModules();
        axisConfigurator.loadServices();
        ConfigurationContextFactory.addModuleService(configContext);
        ConfigurationContextFactory.initApplicationScopeServices(configContext);
        axisConfig.setStart(true);
        return configContext;
    }

    private static void initApplicationScopeServices(ConfigurationContext configCtx) throws AxisFault {
        Iterator serviceGroups = configCtx.getAxisConfiguration().getServiceGroups();
        while (serviceGroups.hasNext()) {
            AxisServiceGroup axisServiceGroup = (AxisServiceGroup)serviceGroups.next();
            String maxScope = SessionUtils.calculateMaxScopeForServiceGroup(axisServiceGroup);
            if (!"application".equals(maxScope)) continue;
            ServiceGroupContext serviceGroupContext = configCtx.createServiceGroupContext(axisServiceGroup);
            configCtx.addServiceGroupContextIntoApplicationScopeTable(serviceGroupContext);
            DependencyManager.initService(serviceGroupContext);
        }
    }

    private static void addModuleService(ConfigurationContext configCtx) throws AxisFault {
        AxisConfiguration axisConfig = configCtx.getAxisConfiguration();
        HashMap modules = axisConfig.getModules();
        if (modules != null && modules.size() > 0) {
            Iterator mpduleItr = modules.values().iterator();
            while (mpduleItr.hasNext()) {
                AxisModule axisModule = (AxisModule)mpduleItr.next();
                Utils.deployModuleServices(axisModule, configCtx);
            }
        }
    }

    private static void setContextPaths(AxisConfiguration axisConfig, ConfigurationContext configContext) {
        Parameter servicePath = axisConfig.getParameter("servicePath");
        if (servicePath != null) {
            String spath = ((String)servicePath.getValue()).trim();
            if (spath.length() > 0) {
                configContext.setServicePath(spath);
            }
        } else {
            configContext.setServicePath("services");
        }
        Parameter contextPath = axisConfig.getParameter("contextRoot");
        if (contextPath != null) {
            String cpath = ((String)contextPath.getValue()).trim();
            if (cpath.length() > 0) {
                configContext.setContextRoot(cpath);
            }
        } else {
            configContext.setContextRoot("axis2");
        }
    }

    public static ConfigurationContext createConfigurationContextFromFileSystem(String path, String axis2xml) throws AxisFault {
        return ConfigurationContextFactory.createConfigurationContext(new FileSystemConfigurator(path, axis2xml));
    }

    public static ConfigurationContext createConfigurationContextFromFileSystem(String path) throws AxisFault {
        return ConfigurationContextFactory.createConfigurationContextFromFileSystem(path, null);
    }

    public static ConfigurationContext createConfigurationContextFromURIs(URL axis2xml, URL repositoy) throws AxisFault {
        return ConfigurationContextFactory.createConfigurationContext(new URLBasedAxisConfigurator(axis2xml, repositoy));
    }

    private static void init(ConfigurationContext configContext) {
        ConfigurationContextFactory.initModules(configContext);
        ConfigurationContextFactory.initTransportSenders(configContext);
    }

    private static void initModules(ConfigurationContext context) {
        AxisConfiguration configuration = context.getAxisConfiguration();
        HashMap modules = configuration.getModules();
        Collection col = modules.values();
        HashMap<AxisModule, AxisFault> faultyModule = new HashMap<AxisModule, AxisFault>();
        Iterator iterator = col.iterator();
        while (iterator.hasNext()) {
            AxisModule axismodule = (AxisModule)iterator.next();
            Module module = axismodule.getModule();
            if (module == null) continue;
            try {
                module.init(context, axismodule);
            }
            catch (AxisFault axisFault) {
                log.info((Object)axisFault.getMessage());
                faultyModule.put(axismodule, axisFault);
            }
        }
        if (faultyModule.size() > 0) {
            Iterator axisModules = faultyModule.keySet().iterator();
            while (axisModules.hasNext()) {
                AxisModule axisModule = (AxisModule)axisModules.next();
                String fileName = axisModule.getFileName() != null ? axisModule.getFileName().toString() : axisModule.getName();
                configuration.getFaultyModules().put(fileName, faultyModule.get(axisModule));
                configuration.removeModule(axisModule.getName(), axisModule.getName());
            }
        }
    }

    private static void initTransportSenders(ConfigurationContext configContext) {
        AxisConfiguration axisConf = configContext.getAxisConfiguration();
        HashMap transportOuts = axisConf.getTransportsOut();
        Iterator values = transportOuts.values().iterator();
        while (values.hasNext()) {
            TransportOutDescription transportOut = (TransportOutDescription)values.next();
            TransportSender sender = transportOut.getSender();
            if (sender == null) continue;
            try {
                sender.init(configContext, transportOut);
            }
            catch (AxisFault axisFault) {
                log.info((Object)Messages.getMessage("transportiniterror", transportOut.getName()));
            }
        }
    }

    public static ConfigurationContext createEmptyConfigurationContext() throws AxisFault {
        AxisConfiguration axisConfiguration = new AxisConfiguration();
        ConfigurationContext configContext = new ConfigurationContext(axisConfiguration);
        if (axisConfiguration.getClusterManager() != null) {
            configContext.initCluster();
        }
        ConfigurationContextFactory.setContextPaths(axisConfiguration, configContext);
        return configContext;
    }

    public static ConfigurationContext createDefaultConfigurationContext() throws Exception {
        return ConfigurationContextFactory.createBasicConfigurationContext("org/apache/axis2/deployment/axis2_default.xml");
    }

    public static ConfigurationContext createBasicConfigurationContext(String resourceName) throws Exception {
        InputStream in = Loader.getResourceAsStream(resourceName);
        AxisConfiguration axisConfig = new AxisConfiguration();
        AxisConfigBuilder builder = new AxisConfigBuilder(in, axisConfig, null);
        builder.populateConfig();
        axisConfig.validateSystemPredefinedPhases();
        ConfigurationContext configContext = new ConfigurationContext(axisConfig);
        if (axisConfig.getClusterManager() != null) {
            configContext.initCluster();
        }
        ConfigurationContextFactory.setContextPaths(axisConfig, configContext);
        return configContext;
    }
}

