/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.addressing.wsdl;

import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.PortType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSDL11DefaultActionPatternHelper {
    private static final Log log = LogFactory.getLog((Class)WSDL11DefaultActionPatternHelper.class);
    private static final String URN = "urn";
    private static final String SLASH = "/";
    private static final String COLON = ":";
    private static final String REQUEST = "Request";
    private static final String RESPONSE = "Response";
    private static final String SOLICIT = "Solicit";
    private static final String FAULT = "Fault";

    public static String generateActionFromInputElement(Definition def, PortType wsdl4jPortType, Operation op, Input input) {
        String targetNamespace = def.getTargetNamespace();
        String delimiter = SLASH;
        if (targetNamespace.toLowerCase().startsWith(URN)) {
            delimiter = COLON;
        }
        String portTypeName = wsdl4jPortType.getQName().getLocalPart();
        String inputName = WSDL11DefaultActionPatternHelper.getNameFromInputElement(op, input);
        StringBuffer sb = new StringBuffer();
        sb.append(targetNamespace);
        if (!targetNamespace.endsWith(delimiter)) {
            sb.append(delimiter);
        }
        sb.append(portTypeName);
        sb.append(delimiter);
        sb.append(inputName);
        String result = sb.toString();
        if (log.isTraceEnabled()) {
            log.trace((Object)("generateActionFromInputElement result: " + result));
        }
        return result;
    }

    private static String getNameFromInputElement(Operation op, Input input) {
        String result = input.getName();
        if (result == null) {
            OperationType operationType = op.getStyle();
            if (null != operationType) {
                if (operationType.equals(OperationType.REQUEST_RESPONSE)) {
                    result = op.getName() + REQUEST;
                } else if (operationType.equals(OperationType.SOLICIT_RESPONSE)) {
                    result = op.getName() + RESPONSE;
                }
            }
            if (result == null) {
                result = op.getName();
            }
        }
        return result;
    }

    protected static String getInputActionFromStringInformation(String messageExchangePattern, String targetNamespace, String portTypeName, String operationName, String inputName) {
        if (messageExchangePattern == null && inputName == null) {
            throw new IllegalArgumentException("One of messageExchangePattern or inputName must the non-null to generate an action.");
        }
        String delimiter = SLASH;
        if (targetNamespace.toLowerCase().startsWith(URN)) {
            delimiter = COLON;
        }
        if (inputName == null) {
            inputName = operationName;
            if (messageExchangePattern.indexOf("in-out") >= 0) {
                inputName = inputName + REQUEST;
            } else if (messageExchangePattern.indexOf("out-in") >= 0) {
                inputName = inputName + RESPONSE;
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append(targetNamespace);
        if (!targetNamespace.endsWith(delimiter)) {
            sb.append(delimiter);
        }
        sb.append(portTypeName);
        sb.append(delimiter);
        sb.append(inputName);
        String result = sb.toString();
        if (log.isTraceEnabled()) {
            log.trace((Object)("getInputActionFromStringInformation result: " + result));
        }
        return result;
    }

    public static String generateActionFromOutputElement(Definition def, PortType wsdl4jPortType, Operation op, Output output) {
        String targetNamespace = def.getTargetNamespace();
        String delimiter = SLASH;
        if (targetNamespace.toLowerCase().startsWith(URN)) {
            delimiter = COLON;
        }
        String portTypeName = wsdl4jPortType.getQName().getLocalPart();
        String outputName = WSDL11DefaultActionPatternHelper.getNameFromOutputElement(op, output);
        StringBuffer sb = new StringBuffer();
        sb.append(targetNamespace);
        if (!targetNamespace.endsWith(delimiter)) {
            sb.append(delimiter);
        }
        sb.append(portTypeName);
        sb.append(delimiter);
        sb.append(outputName);
        String result = sb.toString();
        if (log.isTraceEnabled()) {
            log.trace((Object)("generateActionFromOutputElement result: " + result));
        }
        return result;
    }

    private static String getNameFromOutputElement(Operation op, Output output) {
        String result = output.getName();
        if (result == null) {
            OperationType operationType = op.getStyle();
            if (null != operationType) {
                if (operationType.equals(OperationType.REQUEST_RESPONSE)) {
                    return op.getName() + RESPONSE;
                }
                if (operationType.equals(OperationType.SOLICIT_RESPONSE)) {
                    return op.getName() + SOLICIT;
                }
            }
            if (result == null) {
                result = op.getName();
            }
        }
        return result;
    }

    protected static String getOutputActionFromStringInformation(String messageExchangePattern, String targetNamespace, String portTypeName, String operationName, String outputName) {
        if (messageExchangePattern == null && outputName == null) {
            throw new IllegalArgumentException("One of messageExchangePattern or outputName must the non-null to generate an action.");
        }
        String delimiter = SLASH;
        if (targetNamespace.toLowerCase().startsWith(URN)) {
            delimiter = COLON;
        }
        if (outputName == null) {
            outputName = operationName;
            if (messageExchangePattern.indexOf("in-out") >= 0) {
                outputName = outputName + RESPONSE;
            } else if (messageExchangePattern.indexOf("out-in") >= 0) {
                outputName = outputName + REQUEST;
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append(targetNamespace);
        if (!targetNamespace.endsWith(delimiter)) {
            sb.append(delimiter);
        }
        sb.append(portTypeName);
        sb.append(delimiter);
        sb.append(outputName);
        String result = sb.toString();
        if (log.isTraceEnabled()) {
            log.trace((Object)("getOutputActionFromStringInformation result: " + result));
        }
        return result;
    }

    public static String generateActionFromFaultElement(Definition def, PortType wsdl4jPortType, Operation op, Fault fault) {
        String targetNamespace = def.getTargetNamespace();
        String delimiter = SLASH;
        if (targetNamespace.toLowerCase().startsWith(URN)) {
            delimiter = COLON;
        }
        String portTypeName = wsdl4jPortType.getQName().getLocalPart();
        String operationName = op.getName();
        String faultName = fault.getName();
        StringBuffer sb = new StringBuffer();
        sb.append(targetNamespace);
        if (!targetNamespace.endsWith(delimiter)) {
            sb.append(delimiter);
        }
        sb.append(portTypeName);
        sb.append(delimiter);
        sb.append(operationName);
        sb.append(delimiter);
        sb.append(FAULT);
        sb.append(delimiter);
        sb.append(faultName);
        String result = sb.toString();
        if (log.isTraceEnabled()) {
            log.trace((Object)("generateActionFromFaultElement result: " + result));
        }
        return result;
    }

    protected static String getFaultActionFromStringInformation(String targetNamespace, String portTypeName, String operationName, String faultName) {
        String delimiter = SLASH;
        if (targetNamespace.toLowerCase().startsWith(URN)) {
            delimiter = COLON;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(targetNamespace);
        if (!targetNamespace.endsWith(delimiter)) {
            sb.append(delimiter);
        }
        sb.append(portTypeName);
        sb.append(delimiter);
        sb.append(operationName);
        sb.append(delimiter);
        sb.append(FAULT);
        sb.append(delimiter);
        sb.append(faultName);
        String result = sb.toString();
        if (log.isTraceEnabled()) {
            log.trace((Object)("getFaultActionFromStringInformation result: " + result));
        }
        return result;
    }
}

