/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.environment.spring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.anyline.adapter.EntityAdapter;
import org.anyline.adapter.EnvironmentWorker;
import org.anyline.adapter.init.DefaultEntityAdapter;
import org.anyline.adapter.init.JavaTypeAdapter;
import org.anyline.data.listener.DataSourceListener;
import org.anyline.environment.spring.SpringEnvironmentWorker;
import org.anyline.listener.LoadListener;
import org.anyline.metadata.type.Convert;
import org.anyline.metadata.type.DataType;
import org.anyline.proxy.ConvertProxy;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.ConfigTable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="anyline.environment.configuration.spring")
public class SpringAutoConfiguration
implements InitializingBean {
    private LinkedHashMap<String, LoadListener> listeners;
    private Map<String, DataSourceListener> datasource_listeners;
    private boolean loader_start_status = false;
    private boolean loader_after_status = false;

    @Autowired
    public void setWorker(SpringEnvironmentWorker worker) {
        ConfigTable.setEnvironment((EnvironmentWorker)worker);
        this.loaderStart();
    }

    @Autowired(required=false)
    public void setLoadListeners(Map<String, LoadListener> listeners) {
        if (null == this.listeners) {
            this.listeners = new LinkedHashMap();
        }
        this.listeners.putAll(listeners);
        ArrayList<Map.Entry<String, LoadListener>> entries = new ArrayList<Map.Entry<String, LoadListener>>(this.listeners.entrySet());
        Collections.sort(entries, Comparator.comparingInt(entry -> ((LoadListener)entry.getValue()).index()));
        this.listeners.clear();
        entries.forEach(entry -> {
            LoadListener cfr_ignored_0 = (LoadListener)this.listeners.put((String)entry.getKey(), (LoadListener)entry.getValue());
        });
        this.loaderStart();
    }

    @Autowired(required=false)
    public void setDataSourceListeners(Map<String, DataSourceListener> listeners) {
        this.datasource_listeners = listeners;
    }

    @Autowired(required=false)
    public void setConverts(Map<String, Convert> converts) {
        for (Convert convert : converts.values()) {
            Class origin = convert.getOrigin();
            Class target = convert.getTarget();
            Hashtable<Class, Convert> map = (Hashtable<Class, Convert>)ConvertProxy.converts.get(origin);
            if (null == map) {
                map = new Hashtable<Class, Convert>();
                ConvertProxy.converts.put(origin, map);
            }
            map.put(target, convert);
            DataType type = (DataType)JavaTypeAdapter.types.get(origin);
            if (null == type) continue;
            type.convert(convert);
        }
    }

    @Autowired(required=false)
    public void setEntityAdapter(Map<String, EntityAdapter> adapters) {
        if (ConfigTable.IS_DISABLED_DEFAULT_ENTITY_ADAPTER) {
            for (String key : adapters.keySet()) {
                EntityAdapter adapter = adapters.get(key);
                if (!(adapter instanceof DefaultEntityAdapter)) continue;
                adapters.remove(key);
            }
        }
        EntityAdapterProxy.setAdapters(adapters);
    }

    private void loaderStart() {
        if (!this.loader_start_status && null != this.listeners && null != ConfigTable.environment) {
            this.loader_start_status = true;
            for (LoadListener listener : this.listeners.values()) {
                listener.before(this.datasource_listeners);
            }
            for (LoadListener listener : this.listeners.values()) {
                listener.start();
            }
        }
    }

    public void afterPropertiesSet() {
        if (!this.loader_after_status && null != this.listeners && null != ConfigTable.environment) {
            this.loader_after_status = true;
            for (LoadListener listener : this.listeners.values()) {
                listener.finish();
            }
            for (LoadListener listener : this.listeners.values()) {
                listener.after();
            }
        }
    }
}

