/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.environment.spring.data.jdbc.datasource;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.anyline.data.datasource.DataSourceHolder;
import org.anyline.data.datasource.DataSourceLoader;
import org.anyline.data.jdbc.datasource.JDBCDataSourceLoader;
import org.anyline.data.transaction.TransactionManage;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.environment.spring.data.jdbc.datasource.SpringJDBCDataSourceHolder;
import org.anyline.environment.spring.data.jdbc.runtime.SpringJDBCRuntime;
import org.anyline.environment.spring.data.jdbc.runtime.SpringJDBCRuntimeHolder;
import org.anyline.environment.spring.data.transaction.SpringTransactionManage;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Component;

@Component(value="anyline.environment.spring.data.datasource.loader.jdbc")
public class SpringJDBCDataSourceLoader
extends JDBCDataSourceLoader
implements DataSourceLoader {
    private final SpringJDBCDataSourceHolder holder = SpringJDBCDataSourceHolder.instance();

    public DataSourceHolder holder() {
        return this.holder;
    }

    public List<String> load() {
        ArrayList<String> list = new ArrayList<String>();
        this.holder.loadCache();
        boolean loadDefault = true;
        if (!DataSourceHolder.contains((String)"default")) {
            JdbcTemplate jdbc = null;
            DataSource datasource = null;
            try {
                jdbc = (JdbcTemplate)ConfigTable.environment().getBean(JdbcTemplate.class);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            SpringJDBCRuntime runtime = null;
            if (null != jdbc) {
                try {
                    runtime = SpringJDBCRuntimeHolder.instance().reg("default", jdbc, null);
                    datasource = jdbc.getDataSource();
                    loadDefault = false;
                }
                catch (Exception e) {
                    runtime = null;
                }
            } else {
                try {
                    datasource = (DataSource)ConfigTable.environment().getBean(DataSource.class);
                }
                catch (Exception e) {
                    runtime = null;
                }
                if (null != datasource) {
                    try {
                        runtime = this.holder.create("default", datasource, false);
                        loadDefault = false;
                    }
                    catch (Exception e) {
                        runtime = null;
                        e.printStackTrace();
                    }
                }
            }
            if (null != runtime) {
                String driver = ConfigTable.environment().string("spring.datasource.,anyline.datasource.", "driver,driver-class,driver-class-name");
                String url = ConfigTable.environment().string("spring.datasource.,anyline.datasource.", "url,jdbc-url");
                runtime.setDriver(driver);
                runtime.setUrl(url);
                if (BasicUtil.isNotEmpty((Object)url)) {
                    runtime.setAdapterKey(DataSourceUtil.parseAdapterKey((String)url));
                } else {
                    String adapterKey = ConfigTable.environment().string("spring.datasource.,anyline.datasource.", "adapter");
                    if (BasicUtil.isNotEmpty((Object)adapterKey)) {
                        runtime.setAdapterKey(adapterKey);
                    }
                }
                DataSourceTransactionManager dm = (DataSourceTransactionManager)ConfigTable.environment().getBean(DataSourceTransactionManager.class);
                if (null != dm) {
                    SpringTransactionManage manage = new SpringTransactionManage(dm);
                    TransactionManage.reg((String)"default", (TransactionManage)manage);
                } else {
                    TransactionManage.reg((String)"default", (TransactionManage)new SpringTransactionManage(datasource));
                }
            }
        } else {
            loadDefault = false;
        }
        list.addAll(this.load("spring.datasource", loadDefault));
        list.addAll(this.load("anyline.datasource", loadDefault));
        return list;
    }
}

