/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.runtime;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import javax.sql.DataSource;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.adapter.DriverAdapterHolder;
import org.anyline.data.jdbc.runtime.JDBCRuntimeHolder;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.init.AbstractRuntime;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;

public class JDBCRuntime
extends AbstractRuntime
implements DataRuntime {
    private static Log log = LogProxy.get(JDBCRuntime.class);
    protected DataSource processor;

    public JDBCRuntime(String key, DataSource datasource, DriverAdapter adapter) {
        this.setKey(key);
        this.setProcessor(datasource);
        this.setAdapter(adapter);
    }

    public JDBCRuntime() {
    }

    public DataSource getDataSource() {
        return this.processor;
    }

    public Object getProcessor() {
        return this.processor;
    }

    public void setProcessor(Object processor) {
        this.processor = (DataSource)processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String getFeature(boolean connection) {
        keep = DriverAdapterHolder.keepAdapter((DataRuntime)this, (Object)this.getProcessor());
        feature = DriverAdapterHolder.feature((DataRuntime)this, (Object)this.getProcessor());
        url = null;
        driver = null;
        if (ConfigTable.KEEP_ADAPTER == 1) {
            feature = this.feature;
            url = this.url;
            driver = this.driver;
            keep = true;
            if (BasicUtil.isEmpty((Object)feature)) {
                feature = BasicUtil.concat((String)"_", (String[])new String[]{url, driver});
            }
        }
        if (!keep) {
            connection = true;
            driver = null;
            url = null;
        }
        if (BasicUtil.isEmpty((Object)feature)) {
            if (connection || null == driver || null == url) {
                if (null != this.processor) {
                    con = null;
                    try {
                        con = this.processor.getConnection();
                        meta = con.getMetaData();
                        url = meta.getURL();
                        if (null == this.adapterKey && ConfigTable.KEEP_ADAPTER == 1) {
                            this.adapterKey = DataSourceUtil.parseAdapterKey((String)url);
                        }
                        feature = meta.getDatabaseProductName().toLowerCase().replace(" ", "") + "_" + url;
                        if (null != this.version) ** GOTO lbl42
                        this.version = meta.getDatabaseProductVersion();
                    }
                    catch (Exception e) {
                        JDBCRuntime.log.error("\u83b7\u53d6\u6570\u636e\u6e90\u7279\u5f81 \u5f02\u5e38:", (Throwable)e);
                    }
                    finally {
                        try {
                            con.close();
                        }
                        catch (Exception e) {
                            JDBCRuntime.log.error("\u91ca\u653e\u8fde\u63a5 \u5f02\u5e38:", (Throwable)e);
                        }
                    }
                }
            } else {
                feature = url;
            }
lbl42:
            // 5 sources

            if (null != driver) {
                feature = driver + "_" + feature;
            }
        }
        if (null == this.adapterKey && keep) {
            this.adapterKey = DataSourceUtil.parseAdapterKey((String)feature);
        }
        if (keep) {
            this.feature = feature;
            this.url = url;
        }
        this.setLastFeature(feature);
        return feature;
    }

    public String getVersion() {
        if (null == this.version && null != this.processor) {
            Connection con = null;
            try {
                con = this.processor.getConnection();
                DatabaseMetaData meta = con.getMetaData();
                this.version = meta.getDatabaseProductVersion();
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u6570\u636e\u6e90\u7248\u672c \u5f02\u5e38:", (Throwable)e);
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception e) {
                    log.error("\u91ca\u653e\u8fde\u63a5 \u5f02\u5e38:", (Throwable)e);
                }
            }
        }
        return this.version;
    }

    public boolean destroy() throws Exception {
        JDBCRuntimeHolder.instance().destroy(this.key);
        return true;
    }
}

