/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.anyline.util.BasicUtil;

public class CodeUtil {
    public static String escape(String src) {
        if (BasicUtil.isEmpty((Object)src)) {
            return "";
        }
        StringBuffer tmp = new StringBuffer();
        tmp.ensureCapacity(src.length() * 6);
        for (int i = 0; i < src.length(); ++i) {
            char j = src.charAt(i);
            if (Character.isDigit(j) || Character.isLowerCase(j) || Character.isUpperCase(j)) {
                tmp.append(j);
                continue;
            }
            if (j < '\u0100') {
                tmp.append("%");
                if (j < '\u0010') {
                    tmp.append("0");
                }
                tmp.append(Integer.toString(j, 16));
                continue;
            }
            tmp.append("%u");
            tmp.append(Integer.toString(j, 16));
        }
        return tmp.toString();
    }

    public static String unescape(String src) {
        if (BasicUtil.isEmpty((Object)src)) {
            return "";
        }
        StringBuffer tmp = new StringBuffer();
        tmp.ensureCapacity(src.length());
        int lastPos = 0;
        int pos = 0;
        while (lastPos < src.length()) {
            pos = src.indexOf("%", lastPos);
            if (pos == lastPos) {
                char ch;
                if (src.charAt(pos + 1) == 'u') {
                    ch = (char)Integer.parseInt(src.substring(pos + 2, pos + 6), 16);
                    tmp.append(ch);
                    lastPos = pos + 6;
                    continue;
                }
                ch = (char)Integer.parseInt(src.substring(pos + 1, pos + 3), 16);
                tmp.append(ch);
                lastPos = pos + 3;
                continue;
            }
            if (pos == -1) {
                tmp.append(src.substring(lastPos));
                lastPos = src.length();
                continue;
            }
            tmp.append(src.substring(lastPos, pos));
            lastPos = pos;
        }
        return tmp.toString();
    }

    public static String string2unicode(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        StringBuilder unicode = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            unicode.append("\\u").append(Integer.toHexString(c));
        }
        return unicode.toString();
    }

    public static String unicode2string(String unicode) {
        if (unicode == null || unicode.isEmpty()) {
            return "";
        }
        StringBuilder string = new StringBuilder();
        String[] hex = unicode.split("\\\\u");
        for (int i = 1; i < hex.length; ++i) {
            int data = Integer.parseInt(hex[i], 16);
            string.append((char)data);
        }
        return string.toString();
    }

    public static String string2ascii(String str) {
        if (BasicUtil.isEmpty((Object)str)) {
            return "";
        }
        StringBuffer sbu = new StringBuffer();
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (i != chars.length - 1) {
                sbu.append((int)chars[i]).append(",");
                continue;
            }
            sbu.append((int)chars[i]);
        }
        return sbu.toString();
    }

    public static String ascii2string(String str) {
        if (BasicUtil.isEmpty((Object)str)) {
            return "";
        }
        StringBuffer sbu = new StringBuffer();
        String[] chars = str.split(",");
        for (int i = 0; i < chars.length; ++i) {
            sbu.append((char)Integer.parseInt(chars[i]));
        }
        return sbu.toString();
    }

    public static String urlDecode(String url, String encode) {
        if (BasicUtil.isEmpty((Object)url)) {
            return "";
        }
        String result = "";
        try {
            result = URLDecoder.decode(url, encode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String urlDecode(String url) {
        return CodeUtil.urlDecode(url, "utf-8");
    }

    public static String urlEncode(String url, String encode, int len) {
        if (BasicUtil.isEmpty((Object)url)) {
            return "";
        }
        if (len >= 0 && len < url.length()) {
            url = url.substring(0, len);
        }
        String result = "";
        try {
            result = URLEncoder.encode(url, encode);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return result;
    }

    public static String urlEncode(String url, String encode) {
        return CodeUtil.urlEncode(url, encode, -1);
    }

    public static String urlEncode(String url) {
        return CodeUtil.urlEncode(url, "utf-8", -1);
    }

    public static String urlEncode(String url, int len) {
        return CodeUtil.urlEncode(url, "utf-8", len);
    }

    public static String urlParamEncode(String url, String encode) {
        if (BasicUtil.isEmpty((Object)url)) {
            return "";
        }
        String result = url;
        try {
            int idx = url.indexOf("?");
            if (idx != -1) {
                String param = url.substring(idx + 1);
                url = url.substring(0, idx + 1);
                param = URLEncoder.encode(param, encode);
                result = url + param;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String urlParamEncode(String url) {
        return CodeUtil.urlParamEncode(url, "utf-8");
    }

    public static String urlAsciiEncode(String url) {
        if (BasicUtil.isEmpty((Object)url)) {
            return "";
        }
        String result = url;
        try {
            result = result.replace(" ", "%20");
            result = new URI(result).toASCIIString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String unicode2String(String str) {
        if (BasicUtil.isEmpty((Object)str)) {
            return "";
        }
        Pattern pattern = Pattern.compile("(\\\\u(\\p{XDigit}{4}))");
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            String group = matcher.group(2);
            char ch = (char)Integer.parseInt(group, 16);
            String group1 = matcher.group(1);
            str = str.replace(group1, ch + "");
        }
        return str;
    }

    public static String half2full(String input) {
        if (BasicUtil.isEmpty((Object)input)) {
            return "";
        }
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == ' ') {
                c[i] = 12288;
                continue;
            }
            if (c[i] >= '\u007f') continue;
            c[i] = (char)(c[i] + 65248);
        }
        return new String(c);
    }

    public static final String full2Half(String src) {
        if (BasicUtil.isEmpty((Object)src)) {
            return "";
        }
        StringBuffer outStrBuf = new StringBuffer("");
        String str = "";
        try {
            byte[] b = null;
            int length = src.length();
            for (int i = 0; i < length; ++i) {
                str = src.substring(i, i + 1);
                if (str.equals("\u3000")) {
                    outStrBuf.append(" ");
                    continue;
                }
                b = str.getBytes("unicode");
                if (b[2] == -1) {
                    b[3] = (byte)(b[3] + 32);
                    b[2] = 0;
                    outStrBuf.append(new String(b, "unicode"));
                    continue;
                }
                outStrBuf.append(str);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return outStrBuf.toString();
    }
}

