/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.runtime;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import ognl.MemberAccess;
import ognl.Ognl;
import ognl.OgnlContext;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.CharUtil;
import org.anyline.util.DateUtil;
import org.anyline.util.DefaultOgnlMemberAccess;
import org.anyline.util.regular.RegularUtil;

public class Context {
    protected static Log log = LogProxy.get(Context.class);
    protected Context parent = null;
    protected LinkedHashMap<String, String> htmls = new LinkedHashMap();
    protected LinkedHashMap<String, String> texts = new LinkedHashMap();
    protected String placeholderDefault = "";
    protected LinkedHashMap<String, Object> variables = new LinkedHashMap();

    public LinkedHashMap<String, String> replaces() {
        return this.htmls;
    }

    public LinkedHashMap<String, String> texts() {
        return this.texts;
    }

    public LinkedHashMap<String, Object> variables() {
        return this.variables;
    }

    public Context replace(boolean html, String key, String content) {
        if (null == key || key.trim().isEmpty()) {
            return this;
        }
        if (html) {
            this.htmls.put(key, content);
        } else {
            this.texts.put(key, content);
        }
        return this;
    }

    public Context variable(String key, Object value) {
        if (null != key) {
            this.variables.put(key, value);
        }
        return this;
    }

    public Context variable(Map<String, Object> values) {
        values.putAll(values);
        return this;
    }

    public Context replace(String key, String content) {
        return this.replace(true, key, content);
    }

    public Context replace(boolean parse, String key, File ... words) {
        return this.replace(parse, key, BeanUtil.array2list(new File[][]{words}));
    }

    public Context replace(String key, File ... words) {
        return this.replace(true, key, BeanUtil.array2list(new File[][]{words}));
    }

    public Context replace(boolean parse, String key, List<File> words) {
        if (null != words) {
            StringBuilder content = new StringBuilder();
            for (File word : words) {
                content.append("<word>").append(word.getAbsolutePath()).append("</word>");
            }
            if (parse) {
                this.htmls.put(key, content.toString());
            } else {
                this.texts.put(key, content.toString());
            }
        }
        return this;
    }

    public void replace(String key, List<File> words) {
        this.replace(true, key, words);
    }

    public String getPlaceholderDefault() {
        return this.placeholderDefault;
    }

    public void setPlaceholderDefault(String placeholderDefault) {
        this.placeholderDefault = placeholderDefault;
    }

    public String string(boolean def, String key) {
        Object data = this.data(key);
        if (null == data && def) {
            data = this.placeholderDefault;
        }
        if (null != data) {
            return data.toString();
        }
        return null;
    }

    public String string(String key) {
        return this.string(true, key);
    }

    public Object data(String key) {
        if (null == key) {
            return null;
        }
        String kk = key.trim();
        Object data = null;
        if (BasicUtil.checkEl(kk)) {
            kk = kk.substring(2, kk.length() - 1).trim();
        }
        if (kk.startsWith("aov:") || kk.startsWith("alv:")) {
            return this.aov(kk);
        }
        if (kk.startsWith("{") && kk.endsWith("}")) {
            if ((kk = kk.replace("{", "").replace("}", "")).contains(",")) {
                String[] ks = kk.split(",");
                ArrayList<String> list = new ArrayList<String>();
                for (String k : ks) {
                    if (k.contains(":")) {
                        String[] kv = k.split(":");
                        if (kv.length != 2) continue;
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put(kv[0], kv[1]);
                        continue;
                    }
                    list.add(k);
                }
                data = list;
            }
            if (null != data) {
                return data;
            }
        }
        if (null == (data = this.variables.get(kk))) {
            data = this.htmls.get(kk);
        }
        if (null == data) {
            data = this.texts.get(kk);
        }
        if (null == data && kk.contains(":")) {
            kk = CharUtil.sbc2dbc(kk);
            for (String k : kk.split(":")) {
                Object v;
                if ((k = k.trim()).isEmpty() || null == (v = this.data(k))) continue;
                return v;
            }
        }
        if (null == data) {
            try {
                OgnlContext ognl = new OgnlContext(null, null, (MemberAccess)new DefaultOgnlMemberAccess(true));
                HashMap<String, List<DataRow>> map = new HashMap<String, List<DataRow>>();
                for (String k : this.variables.keySet()) {
                    List<DataRow> v = this.variables.get(k);
                    if (v instanceof String) {
                        String str = (String)((Object)v);
                        try {
                            if (str.startsWith("{") && str.endsWith("}")) {
                                v = DataRow.parseJson(str);
                            }
                            if (str.startsWith("[") && str.endsWith("]")) {
                                v = DataSet.parseJson(str);
                            }
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                    }
                    if (v instanceof DataSet) {
                        DataSet set = (DataSet)((Object)v);
                        set.string2object();
                        v = set.getRows();
                    } else if (v instanceof DataRow) {
                        ((DataRow)((Object)v)).string2object();
                    }
                    map.put(k, v);
                }
                data = Ognl.getValue((String)kk, (Map)ognl, map);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (null == data && null != this.parent) {
            data = this.parent.data(key);
        }
        return data;
    }

    private Object aov(String key) {
        String[] tmps = key.split(":");
        if (tmps.length > 1) {
            String var = tmps[1];
            if (var.equalsIgnoreCase("now") || var.equalsIgnoreCase("date") || var.equalsIgnoreCase("datetime")) {
                if (tmps.length > 2) {
                    String format = tmps[2];
                    return DateUtil.format(format);
                }
                return new Date();
            }
            if (var.equalsIgnoreCase("timestamp")) {
                int len;
                if (tmps.length > 2 && (len = BasicUtil.parseInt(tmps[2], 0).intValue()) == 10) {
                    return System.currentTimeMillis() / 1000L;
                }
                return System.currentTimeMillis();
            }
            if (var.equalsIgnoreCase("random") || var.equalsIgnoreCase("string")) {
                int len = 8;
                if (tmps.length > 2) {
                    len = BasicUtil.parseInt(tmps[2], len);
                }
                return BasicUtil.getRandomString(len);
            }
            if (var.equalsIgnoreCase("number")) {
                if (tmps.length > 3) {
                    int min = BasicUtil.parseInt(tmps[2], 0);
                    int max = BasicUtil.parseInt(tmps[3], 0);
                    return BasicUtil.getRandomNumber(min, max);
                }
                int len = 8;
                if (tmps.length > 2) {
                    len = BasicUtil.parseInt(tmps[2], len);
                }
                return BasicUtil.getRandomNumberString(len);
            }
            if (var.equalsIgnoreCase("uuid")) {
                return UUID.randomUUID().toString();
            }
        }
        return null;
    }

    public String placeholder(String text) {
        String result = text;
        try {
            List<String> ks = RegularUtil.fetch(result, "\\$\\{.*?\\}");
            for (String k : ks) {
                Object value = this.data(k);
                if (null == value) {
                    value = "";
                }
                result = result.replace(k, value.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null == result) {
            result = "";
        }
        return result;
    }

    public Context parent() {
        return this.parent;
    }

    public void parent(Context parent) {
        this.parent = parent;
    }

    public Context clone() {
        Context clone = new Context();
        clone.htmls.putAll(this.htmls);
        clone.texts.putAll(this.texts);
        clone.variables.putAll(this.variables);
        clone.placeholderDefault = this.placeholderDefault;
        clone.parent = this;
        return clone;
    }
}

