/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.sparql.relation.api;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.concepts.BinaryRelationImpl;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.concepts.RelationImpl;
import org.aksw.jena_sparql_api.concepts.RelationJoiner;
import org.aksw.jena_sparql_api.concepts.RelationUtils;
import org.aksw.jena_sparql_api.concepts.TernaryRelationImpl;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.var.VarUtils;
import org.aksw.jenax.sparql.relation.api.BinaryRelation;
import org.aksw.jenax.sparql.relation.api.HasElement;
import org.aksw.jenax.sparql.relation.api.TernaryRelation;
import org.aksw.jenax.sparql.relation.api.UnaryRelation;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;

public interface Relation
extends HasElement {
    public List<Var> getVars();

    default public Set<Var> getNonDistinguishedVars() {
        Set<Var> mentionedVars = this.getVarsMentioned();
        HashSet<Var> markedVars = new HashSet<Var>(this.getVars());
        Sets.SetView result = Sets.difference(mentionedVars, markedVars);
        return result;
    }

    default public Relation rename(Function<String, String> renameFn, Var ... constantVars) {
        HashSet<Var> constants = new HashSet<Var>(Arrays.asList(constantVars));
        Set<Var> vars = this.getVarsMentioned();
        Map<Var, Var> oldToNew = vars.stream().filter((? super T v) -> !constants.contains(v)).collect(Collectors.toMap(v -> v, v -> Var.alloc((String)((String)renameFn.apply(v.getName())))));
        Element newElement = ElementUtils.createRenamedElement((Element)this.getElement(), oldToNew);
        List<Var> newVars = this.getVars().stream().map(v -> oldToNew.getOrDefault(v, (Var)v)).collect(Collectors.toList());
        RelationImpl result = new RelationImpl(newElement, newVars);
        return result;
    }

    default public Relation rename(List<Var> targetVars) {
        return RelationUtils.rename(this, targetVars);
    }

    default public UnaryRelation toUnaryRelation() {
        List<Var> vars = this.getVars();
        if (vars.size() != 1) {
            throw new UnsupportedOperationException();
        }
        Element e = this.getElement();
        Concept result = new Concept(e, vars.get(0));
        return result;
    }

    default public BinaryRelation toBinaryRelation() {
        List<Var> vars = this.getVars();
        if (vars.size() != 2) {
            throw new UnsupportedOperationException();
        }
        Element e = this.getElement();
        BinaryRelationImpl result = new BinaryRelationImpl(e, vars.get(0), vars.get(1));
        return result;
    }

    default public TernaryRelation toTernaryRelation() {
        List<Var> vars = this.getVars();
        if (vars.size() != 3) {
            throw new UnsupportedOperationException();
        }
        Element e = this.getElement();
        TernaryRelationImpl result = new TernaryRelationImpl(e, vars.get(0), vars.get(1), vars.get(2));
        return result;
    }

    default public Set<Var> getVarsMentioned() {
        Element e = this.getElement();
        Set result = ElementUtils.getVarsMentioned((Element)e);
        List<Var> distinguishedVars = this.getVars();
        result.addAll(distinguishedVars);
        return result;
    }

    default public Relation applyNodeTransform(NodeTransform nodeTransform) {
        return Relation.applyDefaultNodeTransform(this, nodeTransform);
    }

    public static Relation applyDefaultNodeTransform(Relation r, NodeTransform nodeTransform) {
        List<Var> transformedVars = r.getVars().stream().map(v -> VarUtils.applyNodeTransform((Var)v, (NodeTransform)nodeTransform)).collect(Collectors.toList());
        Element transformedElement = ElementUtils.applyNodeTransform((Element)r.getElement(), (NodeTransform)nodeTransform);
        RelationImpl result = new RelationImpl(transformedElement, transformedVars);
        return result;
    }

    default public RelationJoiner joinOn(List<Var> vars) {
        return new RelationJoiner(this, vars);
    }

    default public RelationJoiner joinOn(Var ... vars) {
        return RelationJoiner.from(this, vars);
    }

    default public RelationJoiner prependOn(Var ... vars) {
        return RelationJoiner.from(this, vars).filterRelationFirst(true);
    }

    default public Relation project(List<Var> vars) {
        return new RelationImpl(this.getElement(), vars);
    }

    default public Relation project(Var ... vars) {
        return this.project(Arrays.asList(vars));
    }

    default public Relation filter(Expr ... exprs) {
        return this.filter(Arrays.asList(exprs));
    }

    default public Relation filter(Iterable<Expr> exprs) {
        Relation result = !exprs.iterator().hasNext() ? this : this.filter(ExprUtils.andifyBalanced(exprs));
        return result;
    }

    default public Relation filter(Expr expr) {
        ArrayList<Object> elts = new ArrayList<Object>();
        elts.addAll(this.getElements());
        elts.add(new ElementFilter(expr));
        Element newElt = ElementUtils.groupIfNeeded(elts);
        List<Var> vars = this.getVars();
        RelationImpl result = new RelationImpl(newElt, vars);
        return result;
    }

    default public Query toQuery() {
        Query result = RelationUtils.createQuery(this);
        return result;
    }

    default public List<Element> getElements() {
        return ElementUtils.toElementList((Element)this.getElement());
    }
}

