/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concepts;

import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.jena_sparql_api.concepts.BinaryRelationImpl;
import org.aksw.jena_sparql_api.concepts.RelationImpl;
import org.aksw.jena_sparql_api.concepts.TernaryRelationImpl;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.aksw.jenax.arq.util.expr.NodeValueUtils;
import org.aksw.jenax.arq.util.prologue.PrologueUtils;
import org.aksw.jenax.arq.util.quad.QuadPatternUtils;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.syntax.QueryGenerationUtils;
import org.aksw.jenax.arq.util.var.VarGeneratorBlacklist;
import org.aksw.jenax.arq.util.var.VarUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.sparql.relation.api.BinaryRelation;
import org.aksw.jenax.sparql.relation.api.HasElement;
import org.aksw.jenax.sparql.relation.api.Relation;
import org.aksw.jenax.sparql.relation.api.TernaryRelation;
import org.apache.jena.ext.com.google.common.collect.Streams;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.E_Bound;
import org.apache.jena.sparql.expr.E_Conditional;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.AggCountVarDistinct;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementUnion;
import org.apache.jena.sparql.syntax.PatternVars;
import org.apache.jena.sparql.syntax.Template;
import org.apache.jena.sparql.syntax.syntaxtransform.NodeTransformSubst;

public class RelationUtils {
    public static final TernaryRelation SPO = new TernaryRelationImpl((Element)ElementUtils.createElementTriple((Node)Vars.s, (Node)Vars.p, (Node)Vars.o), Vars.s, Vars.p, Vars.o);

    public static TernaryRelation createTernaryRelation(Node s, Node p, Node o) {
        ArrayList<E_Equals> exprs = new ArrayList<E_Equals>(3);
        List<Node> nodes = Arrays.asList(s, p, o);
        for (int i = 0; i < 3; ++i) {
            Node n = nodes.get(i);
            if (!n.isConcrete()) continue;
            Var v = (Var)Vars.spo.get(i);
            exprs.add(new E_Equals((Expr)new ExprVar(v), (Expr)NodeValue.makeNode((Node)n)));
        }
        ElementTriplesBlock elt = ElementUtils.createElementTriple((Node)Vars.s, (Node)Vars.p, (Node)Vars.o);
        if (!exprs.isEmpty()) {
            Expr expr = ExprUtils.andifyBalanced(exprs);
            elt = ElementUtils.createElementGroup((Element[])new Element[]{elt, new ElementFilter(expr)});
        }
        return new TernaryRelationImpl((Element)elt, Vars.s, Vars.p, Vars.o);
    }

    public static Relation rename(Relation r, List<Var> targetVars) {
        List<Var> rVars = r.getVars();
        Map<Var, Node> map = RelationUtils.createRenameVarMap(r.getVarsMentioned(), rVars, targetVars);
        Relation result = r.applyNodeTransform((NodeTransform)new NodeTransformSubst(map));
        return result;
    }

    public static Element renameNodes(Relation r, List<? extends Node> targetNodes) {
        List<Var> tgtVars = targetNodes.stream().map(v -> (Var)v).collect(Collectors.toList());
        Relation joined = new RelationImpl((Element)new ElementGroup(), tgtVars).joinOn(tgtVars).with(r, new Var[0]);
        Element result = joined.getElement();
        return result;
    }

    public static Map<Var, Node> createRenameVarMap(Set<Var> mentionedVars, List<Var> rVars, List<? extends Node> targetNodes) {
        LinkedHashSet<Var> relationVars = new LinkedHashSet<Var>(rVars);
        LinkedHashSet<? extends Node> vs = new LinkedHashSet<Node>(targetNodes);
        if (vs.size() != relationVars.size()) {
            throw new IllegalArgumentException("Number of distinct variables of the relation must match the number of distinct target variables");
        }
        Map<Var, Node> rename = Streams.zip(relationVars.stream(), vs.stream(), (a, b) -> new AbstractMap.SimpleEntry<Var, Node>((Var)a, (Node)b)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Sets.SetView remainingVars = Sets.difference(mentionedVars, relationVars);
        VarGeneratorBlacklist varGen = VarGeneratorBlacklist.create((Collection)remainingVars);
        Set targetVars = targetNodes.stream().filter(Node::isVariable).map(x -> (Var)x).collect(Collectors.toSet());
        Map map = VarUtils.createDistinctVarMap(targetVars, (Collection)remainingVars, (boolean)true, (Generator)varGen);
        rename.putAll(map);
        return rename;
    }

    public static Relation align(Collection<? extends Relation> relations, List<Var> vars) {
        List tmp = relations.stream().map(r -> RelationUtils.rename(r, vars)).collect(Collectors.toList());
        List es = tmp.stream().map(HasElement::getElement).collect(Collectors.toList());
        Element e = ElementUtils.unionIfNeeded(es);
        RelationImpl result = new RelationImpl(e, vars);
        return result;
    }

    public static Relation groupBy(Relation r, Var aggVar, Var resultVar, boolean includeAbsent) {
        Query query = new Query();
        query.setQuerySelectType();
        query.setQueryPattern(r.getElement());
        ExprVar ev = new ExprVar(aggVar);
        ExprVar e = includeAbsent ? new E_Conditional((Expr)new E_Bound((Expr)ev), (Expr)ev, (Expr)NodeValueUtils.NV_ABSENT) : ev;
        Expr tmp = query.allocAggregate((Aggregator)new AggCountVarDistinct((Expr)e));
        List<Var> vars = r.getVars();
        List groupVars = vars.stream().filter(v -> !aggVar.equals(v)).collect(Collectors.toList());
        query.addProjectVars(groupVars);
        query.getProject().add(resultVar, tmp);
        ArrayList<Var> newVars = new ArrayList<Var>(groupVars);
        newVars.add(resultVar);
        for (Var groupVar : groupVars) {
            query.addGroupBy((Node)groupVar);
        }
        RelationImpl result = new RelationImpl((Element)new ElementSubQuery(query), newVars);
        return result;
    }

    public static Relation fromQuery(String queryStr) {
        PrefixMappingImpl pm = new PrefixMappingImpl();
        pm.setNsPrefixes(PrefixMapping.Extended);
        return RelationUtils.fromQuery(queryStr, (PrefixMapping)pm);
    }

    public static Relation fromQuery(String queryStr, PrefixMapping prefixMapping) {
        Query query = new Query();
        query.setPrefixMapping(prefixMapping);
        QueryFactory.parse((Query)query, (String)queryStr, (String)"http://www.example.org/base/", (Syntax)Syntax.syntaxARQ);
        Relation result = RelationUtils.fromQuery(query);
        return result;
    }

    public static Relation fromQuery(Query query) {
        RelationImpl result;
        if (query.isSelectType()) {
            List vars = query.getProjectVars();
            boolean needsWrapping = QueryGenerationUtils.needsWrappingByFeatures((Query)query);
            ElementSubQuery element = needsWrapping ? new ElementSubQuery(query) : query.getQueryPattern();
            result = new RelationImpl((Element)element, vars);
        } else if (query.isConstructType()) {
            Template template = query.getConstructTemplate();
            ArrayList<Var> vars = new ArrayList<Var>(QuadPatternUtils.getVarsMentioned((Iterable)template.getQuads()));
            Element element = query.getQueryPattern();
            result = new RelationImpl(element, vars);
        } else {
            throw new RuntimeException("SELECT or CONSTRUCT query form expected, instead got " + query);
        }
        return result;
    }

    public static Triple extractTriple(BinaryRelation relation) {
        Element e = relation.getElement();
        Triple result = ElementUtils.extractTriple((Element)e);
        return result;
    }

    public static BinaryRelation and(BinaryRelation a, BinaryRelation b, boolean transformInPlaceIfApplicable) {
        ElementGroup eg;
        boolean isInPlace;
        Element ae = a.getElement();
        Element be = b.getElement();
        Collection vas = PatternVars.vars((Element)ae);
        Collection vbs = PatternVars.vars((Element)be);
        Map varMap = VarUtils.createDistinctVarMap((Collection)vas, (Collection)vbs, (boolean)true, null);
        varMap.put(b.getSourceVar(), a.getTargetVar());
        Element ce = ElementUtils.createRenamedElement((Element)be, (Map)varMap);
        boolean bl = isInPlace = ae instanceof ElementGroup && transformInPlaceIfApplicable;
        if (isInPlace) {
            eg = (ElementGroup)ae;
        } else {
            eg = new ElementGroup();
            eg.addElement(ae);
        }
        eg.addElement(ce);
        BinaryRelationImpl result = new BinaryRelationImpl((Element)eg, a.getSourceVar(), varMap.getOrDefault(b.getTargetVar(), a.getSourceVar()));
        return result;
    }

    public static BinaryRelation union(BinaryRelation a, BinaryRelation b, boolean transformInPlaceIfApplicable) {
        boolean isInPlace;
        ElementUnion u;
        Element ae = a.getElement();
        if (transformInPlaceIfApplicable && a.getElement() instanceof ElementUnion) {
            u = (ElementUnion)ae;
            isInPlace = true;
        } else {
            u = new ElementUnion();
            u.addElement(a.getElement());
            isInPlace = false;
        }
        HashMap<Var, Var> varMap = new HashMap<Var, Var>();
        Collection vas = PatternVars.vars((Element)a.getElement());
        Collection vbs = PatternVars.vars((Element)b.getElement());
        VarUtils.createDistinctVarMap((Collection)vbs, (Collection)vas, (boolean)true, null);
        varMap.put(b.getSourceVar(), a.getSourceVar());
        varMap.put(b.getTargetVar(), a.getTargetVar());
        Element c = ElementUtils.createRenamedElement((Element)b.getElement(), varMap);
        u.addElement(c);
        BinaryRelation result = isInPlace ? a : new BinaryRelationImpl((Element)u, a.getSourceVar(), a.getTargetVar());
        return result;
    }

    public static BinaryRelation createRelation(String propertyUri, boolean isInverse, PrefixMapping prefixMapping) {
        String p = prefixMapping == null ? propertyUri : prefixMapping.expandPrefix(propertyUri);
        Node node = NodeFactory.createURI((String)p);
        BinaryRelation result = RelationUtils.createRelation(node, isInverse);
        return result;
    }

    public static BinaryRelation createRelation(Node property, boolean isInverse) {
        Triple t = isInverse ? new Triple((Node)Vars.o, property, (Node)Vars.s) : new Triple((Node)Vars.s, property, (Node)Vars.o);
        ElementTriplesBlock element = ElementUtils.createElement((Triple)t);
        BinaryRelationImpl result = new BinaryRelationImpl((Element)element, Vars.s, Vars.o);
        return result;
    }

    public static BinaryRelation createRelation(Property property, boolean isInverse) {
        BinaryRelation result = RelationUtils.createRelation(property.asNode(), isInverse);
        return result;
    }

    public static BinaryRelation createRelation(Expr expr, boolean isInverse) {
        BinaryRelationImpl result = new BinaryRelationImpl((Element)new ElementFilter(expr), Vars.p, Vars.o);
        return result;
    }

    public static Query createQuery(Relation relation) {
        Query result;
        Element e = relation.getElement();
        List<Var> vars = relation.getVars();
        if (e instanceof ElementSubQuery) {
            result = ((ElementSubQuery)e).getQuery().cloneQuery();
            HashSet removals = new HashSet(result.getProject().getVars());
            removals.removeAll(vars);
            VarExprList project = result.getProject();
            removals.forEach(arg_0 -> ((VarExprList)project).remove(arg_0));
        } else {
            Prologue prologue = PrologueUtils.newPrologueAsGiven();
            result = new Query(prologue);
            result.setQuerySelectType();
            result.setQueryPattern(e);
            VarExprList project = result.getProject();
            vars.forEach(arg_0 -> ((VarExprList)project).add(arg_0));
        }
        return result;
    }
}

