/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concepts;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.aksw.commons.collections.SetUtils;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.var.VarUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.sparql.relation.api.BinaryRelation;
import org.aksw.jenax.stmt.parser.element.SparqlElementParserImpl;
import org.aksw.jenax.stmt.parser.prologue.SparqlPrologueParserImpl;
import org.aksw.jenax.stmt.parser.query.SparqlQueryParserImpl;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.PatternVars;

public class BinaryRelationImpl
implements BinaryRelation {
    private Var sourceVar;
    private Var targetVar;
    private Element element;

    public BinaryRelationImpl(Element element, Var sourceVar, Var targetVar) {
        this.element = element;
        this.sourceVar = sourceVar;
        this.targetVar = targetVar;
    }

    @Override
    public List<Var> getVars() {
        return Arrays.asList(this.sourceVar, this.targetVar);
    }

    @Override
    public Var getSourceVar() {
        return this.sourceVar;
    }

    @Override
    public Var getTargetVar() {
        return this.targetVar;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    public static BinaryRelation create(String elementStr, String sourceVarName, String targetVarName) {
        SparqlElementParserImpl parser = SparqlElementParserImpl.create((Syntax)Syntax.syntaxARQ, null);
        BinaryRelation result = BinaryRelationImpl.create(elementStr, sourceVarName, targetVarName, (Function<String, ? extends Element>)parser);
        return result;
    }

    public static BinaryRelation create(String prologueStr, String elementStr, String sourceVarName, String targetVarName) {
        SparqlQueryParserImpl queryParser = SparqlQueryParserImpl.create();
        SparqlPrologueParserImpl prologueParser = new SparqlPrologueParserImpl((Function)queryParser);
        Prologue prologue = (Prologue)prologueParser.apply((Object)prologueStr);
        BinaryRelation result = BinaryRelationImpl.create(elementStr, sourceVarName, targetVarName, prologue);
        return result;
    }

    public static BinaryRelation create(String elementStr, String sourceVarName, String targetVarName, Prologue prologue) {
        SparqlElementParserImpl parser = SparqlElementParserImpl.create((Syntax)Syntax.syntaxARQ, (Prologue)prologue);
        BinaryRelation result = BinaryRelationImpl.create(elementStr, sourceVarName, targetVarName, (Function<String, ? extends Element>)parser);
        return result;
    }

    public static BinaryRelation create(String elementStr, String sourceVarName, String targetVarName, Function<String, ? extends Element> elementParser) {
        ElementGroup group;
        List elements;
        Element element;
        boolean isEnclosed;
        Var sourceVar = Var.alloc((String)sourceVarName);
        Var targetVar = Var.alloc((String)targetVarName);
        Object tmp = elementStr.trim();
        boolean bl = isEnclosed = ((String)tmp).startsWith("{") && ((String)tmp).endsWith("}");
        if (!isEnclosed) {
            tmp = "{" + (String)tmp + "}";
        }
        if ((element = elementParser.apply((String)tmp)) instanceof ElementGroup && (elements = (group = (ElementGroup)element).getElements()).size() == 1) {
            element = (Element)elements.get(0);
        }
        BinaryRelationImpl result = new BinaryRelationImpl(element, sourceVar, targetVar);
        return result;
    }

    public Set<Var> getInnerVars() {
        Set result = SetUtils.asSet((Iterable)PatternVars.vars((Element)this.element));
        result.remove(this.sourceVar);
        result.remove(this.targetVar);
        return result;
    }

    @Override
    public BinaryRelation applyNodeTransform(NodeTransform nodeTransform) {
        Var s = VarUtils.applyNodeTransform((Var)this.sourceVar, (NodeTransform)nodeTransform);
        Var t = VarUtils.applyNodeTransform((Var)this.targetVar, (NodeTransform)nodeTransform);
        Element e = ElementUtils.applyNodeTransform((Element)this.element, (NodeTransform)nodeTransform);
        BinaryRelationImpl result = new BinaryRelationImpl(e, s, t);
        return result;
    }

    public static BinaryRelation create(Path path) {
        BinaryRelationImpl result = new BinaryRelationImpl((Element)ElementUtils.createElement((TriplePath)new TriplePath((Node)Vars.s, path, (Node)Vars.o)), Vars.s, Vars.o);
        return result;
    }

    public static BinaryRelation create(Node p) {
        BinaryRelationImpl result = new BinaryRelationImpl((Element)ElementUtils.createElement((Triple)new Triple((Node)Vars.s, p, (Node)Vars.o)), Vars.s, Vars.o);
        return result;
    }

    public static BinaryRelation create(Resource p) {
        BinaryRelation result = BinaryRelationImpl.create(p.asNode());
        return result;
    }

    public static BinaryRelation create(String p) {
        BinaryRelation result = BinaryRelationImpl.create(NodeFactory.createURI((String)p));
        return result;
    }

    public static BinaryRelation createFwd(Var s, Node p, Var o) {
        BinaryRelationImpl result = new BinaryRelationImpl((Element)ElementUtils.createElementTriple((Node)s, (Node)p, (Node)o), s, o);
        return result;
    }

    public static BinaryRelation createBwd(Var s, Node p, Var o) {
        BinaryRelationImpl result = new BinaryRelationImpl((Element)ElementUtils.createElementTriple((Node)s, (Node)p, (Node)o), o, s);
        return result;
    }

    public static BinaryRelation create(Var s, Node p, Var o, boolean isFwd) {
        BinaryRelation result = isFwd ? BinaryRelationImpl.createFwd(s, p, o) : BinaryRelationImpl.createBwd(s, p, o);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.element == null ? 0 : this.element.hashCode());
        result = 31 * result + (this.sourceVar == null ? 0 : this.sourceVar.hashCode());
        result = 31 * result + (this.targetVar == null ? 0 : this.targetVar.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryRelationImpl other = (BinaryRelationImpl)obj;
        if (this.element == null ? other.element != null : !this.element.equals((Object)other.element)) {
            return false;
        }
        if (this.sourceVar == null ? other.sourceVar != null : !this.sourceVar.equals((Object)other.sourceVar)) {
            return false;
        }
        return !(this.targetVar == null ? other.targetVar != null : !this.targetVar.equals((Object)other.targetVar));
    }

    public String toString() {
        String result = this.sourceVar + " " + this.targetVar + " | " + this.element;
        return result;
    }

    public static BinaryRelation empty() {
        return new BinaryRelationImpl((Element)new ElementGroup(), Vars.s, Vars.s);
    }

    public static BinaryRelation empty(Var var) {
        return new BinaryRelationImpl((Element)new ElementGroup(), var, var);
    }
}

