/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.concept.parser;

import java.util.List;
import java.util.function.Function;
import org.aksw.jena_sparql_api.concept.parser.SparqlConceptParser;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;

public class SparqlConceptParserImpl
implements SparqlConceptParser {
    private Function<String, Element> elementParser;

    public SparqlConceptParserImpl(Function<String, Element> elementParser) {
        this.elementParser = elementParser;
    }

    @Override
    public Concept apply(String conceptStr) {
        Concept result = SparqlConceptParserImpl.parse(conceptStr, this.elementParser);
        return result;
    }

    public static Concept parse(String conceptStr, Function<String, Element> elementParser) {
        String[] splits = conceptStr.split("\\|", 2);
        if (splits.length != 2) {
            throw new RuntimeException("Invalid string: " + conceptStr);
        }
        String varName = splits[0].trim();
        if (varName.charAt(0) != '?') {
            throw new RuntimeException("var name must start with '?'");
        }
        varName = varName.substring(1);
        Concept result = SparqlConceptParserImpl.create(splits[1], varName, elementParser);
        return result;
    }

    public static Concept create(String elementStr, String varName, Function<String, Element> elementParser) {
        ElementGroup group;
        List elements;
        Var var = Var.alloc((String)varName);
        String tmp = elementStr.trim();
        Element element = elementParser.apply(tmp);
        if (element instanceof ElementGroup && (elements = (group = (ElementGroup)element).getElements()).size() == 1) {
            element = (Element)elements.get(0);
        }
        Concept result = new Concept(element, var);
        return result;
    }
}

