/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.jena.geosparql.implementation.GeometryWrapper;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.geojson.GeoJsonWriter;

public class RdfJsonUtils {
    public static JsonElement toJson(RDFNode rdfNode, int maxDepth, boolean flat) {
        JsonElement result = RdfJsonUtils.toJson(rdfNode, 0, maxDepth, flat);
        return result;
    }

    public static JsonObject toJson(Resource rdfNode, int maxDepth, boolean flat) {
        JsonElement tmp = RdfJsonUtils.toJson((RDFNode)rdfNode, 0, maxDepth, flat);
        JsonObject result = tmp.getAsJsonObject();
        return result;
    }

    public static JsonArray toJson(Collection<? extends RDFNode> rdfNodes, int maxDepth, boolean flat) {
        JsonArray result = new JsonArray();
        for (RDFNode rDFNode : rdfNodes) {
            JsonElement jsonElement = RdfJsonUtils.toJson(rDFNode, maxDepth, flat);
            result.add(jsonElement);
        }
        return result;
    }

    public static JsonArray toJson(ResultSet rs, int maxDepth, boolean flat) {
        JsonArray result = new JsonArray();
        List vars = rs.getResultVars();
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            JsonObject row = RdfJsonUtils.toJson(qs, maxDepth, flat);
            if (flat && vars.size() == 1) {
                result.add((JsonElement)((Map.Entry)row.entrySet().iterator().next()).getValue());
                continue;
            }
            result.add((JsonElement)row);
        }
        return result;
    }

    public static JsonObject toJson(QuerySolution qs, int maxDepth, boolean flat) {
        JsonObject row = new JsonObject();
        Iterator it = qs.varNames();
        while (it.hasNext()) {
            String varName = (String)it.next();
            RDFNode rdfNode = qs.get(varName);
            JsonElement jsonElement = RdfJsonUtils.toJson(rdfNode, maxDepth, flat);
            row.add(varName, jsonElement);
        }
        return row;
    }

    public static JsonElement toJson(RDFNode rdfNode, int depth, int maxDepth, boolean flat) {
        JsonNull result;
        if (depth >= maxDepth) {
            result = null;
        } else if (rdfNode == null) {
            result = JsonNull.INSTANCE;
        } else if (rdfNode.isLiteral()) {
            Node node = rdfNode.asNode();
            Object obj = node.getLiteralValue();
            if (obj instanceof String) {
                String value = (String)obj;
                result = new JsonPrimitive(value);
            } else if (obj instanceof Number) {
                Number value = (Number)obj;
                result = new JsonPrimitive(value);
            } else if (obj instanceof Boolean) {
                Boolean value = (Boolean)obj;
                result = new JsonPrimitive(value);
            } else if (obj instanceof GeometryWrapper) {
                WKTReader wktReader = new WKTReader();
                try {
                    Geometry geom = wktReader.read(rdfNode.asLiteral().getLexicalForm());
                    GeoJsonWriter geoJsonWriter = new GeoJsonWriter();
                    String jsonString = geoJsonWriter.write(geom);
                    Gson gson = new Gson();
                    result = (JsonElement)gson.fromJson(jsonString, JsonObject.class);
                }
                catch (ParseException e) {
                    throw new RuntimeException("Invalid WKT : " + rdfNode);
                }
            } else {
                String value = rdfNode.asLiteral().getLexicalForm();
                result = new JsonPrimitive(value);
            }
        } else if (rdfNode.isResource()) {
            JsonObject tmp = new JsonObject();
            Resource r = rdfNode.asResource();
            if (r.isURIResource()) {
                tmp.addProperty("id", r.getURI());
                tmp.addProperty("id_type", "uri");
            } else if (r.isAnon()) {
                tmp.addProperty("id", r.getId().getLabelString());
                tmp.addProperty("id_type", "bnode");
            }
            List stmts = r.listProperties().toList();
            Map pos = stmts.stream().collect(Collectors.groupingBy(Statement::getPredicate, Collectors.mapping(Statement::getObject, Collectors.toList())));
            for (Map.Entry e : pos.entrySet()) {
                JsonArray arr = new JsonArray();
                Property p = e.getKey();
                String k = p.getLocalName();
                for (RDFNode o : e.getValue()) {
                    JsonElement v = RdfJsonUtils.toJson(o, depth + 1, maxDepth, flat);
                    if (v == null) continue;
                    arr.add(v);
                }
                if (arr.size() <= 0) continue;
                if (flat && arr.size() == 1) {
                    tmp.add(k, arr.get(0));
                    continue;
                }
                tmp.add(k, (JsonElement)arr);
            }
            result = tmp;
        } else {
            throw new RuntimeException("Unknown node type: " + rdfNode);
        }
        return result;
    }
}

