/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collector.domain;

import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import org.aksw.commons.collector.core.AggFinish;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.lambda.serializable.SerializableFunction;

@FunctionalInterface
public interface Aggregator<B, T> {
    public Accumulator<B, T> createAccumulator();

    default public <U> Aggregator<B, U> finish(SerializableFunction<T, U> transform) {
        return AggFinish.create(this, transform);
    }

    default public Optional<T> accumulateAll(Stream<? extends B> stream) {
        try (Stream<B> tmp = stream;){
            Optional<T> optional = this.accumulateAll(stream.iterator());
            return optional;
        }
    }

    default public Optional<T> accumulateAll(Iterable<? extends B> iterable) {
        return this.accumulateAll(iterable.iterator());
    }

    default public Optional<T> accumulateAll(Iterator<? extends B> it) {
        Accumulator<B, T> acc = this.createAccumulator();
        while (it.hasNext()) {
            B item = it.next();
            acc.accumulate(item);
        }
        return Optional.ofNullable(acc.getValue());
    }
}

