/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collector.core;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import org.aksw.commons.collector.core.SerializableCollectorImpl;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.collector.domain.ParallelAggregator;

public class ParallelAggregators {
    public static <T, V, C extends Collection<V>> Accumulator<T, C> combineAccumulators(Accumulator<T, C> needle, Accumulator<T, C> haystack, UnaryOperator<Accumulator<T, C>> accumulatorCloner, Function<? super V, ? extends T> valueToItem) {
        if (((Collection)needle.getValue()).size() > ((Collection)haystack.getValue()).size()) {
            Accumulator<T, C> tmp = needle;
            needle = haystack;
            haystack = tmp;
        }
        Accumulator result = (Accumulator)accumulatorCloner.apply(haystack);
        for (Object value : (Collection)needle.getValue()) {
            T reductionItem = valueToItem.apply(value);
            result.accumulate(reductionItem);
        }
        return result;
    }

    public static <I, O, ACC extends Accumulator<I, O>> Collector<I, ?, O> createCollector(ParallelAggregator<I, O, ACC> agg) {
        return SerializableCollectorImpl.create(agg::createAccumulator, Accumulator::accumulate, agg::combine, Accumulator::getValue);
    }
}

