/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collector.core;

import java.io.Serializable;
import java.util.function.Function;
import org.aksw.commons.collector.core.AccWrapper;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.collector.domain.ParallelAggregator;

public class AggOutputTransform<I, O, P, SUBACC extends Accumulator<I, O>, SUBAGG extends ParallelAggregator<I, O, SUBACC>>
implements ParallelAggregator<I, P, AccOutputTransform<I, O, P, SUBACC>>,
Serializable {
    private static final long serialVersionUID = 0L;
    protected SUBAGG subAgg;
    protected Function<? super O, ? extends P> outputTransform;

    public AggOutputTransform(SUBAGG subAgg, Function<? super O, ? extends P> outputTransform) {
        this.subAgg = subAgg;
        this.outputTransform = outputTransform;
    }

    @Override
    public AccOutputTransform<I, O, P, SUBACC> createAccumulator() {
        Object subAcc = this.subAgg.createAccumulator();
        return new AccOutputTransformImpl(this, subAcc, this.outputTransform);
    }

    @Override
    public AccOutputTransform<I, O, P, SUBACC> combine(AccOutputTransform<I, O, P, SUBACC> a, AccOutputTransform<I, O, P, SUBACC> b) {
        Accumulator accA = (Accumulator)a.getSubAcc();
        Accumulator accB = (Accumulator)b.getSubAcc();
        Accumulator combined = this.subAgg.combine((Accumulator)accA, (Accumulator)accB);
        return new AccOutputTransformImpl(this, combined, this.outputTransform);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.outputTransform == null ? 0 : this.outputTransform.hashCode());
        result = 31 * result + (this.subAgg == null ? 0 : this.subAgg.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggOutputTransform other = (AggOutputTransform)obj;
        if (this.outputTransform == null ? other.outputTransform != null : !this.outputTransform.equals(other.outputTransform)) {
            return false;
        }
        return !(this.subAgg == null ? other.subAgg != null : !this.subAgg.equals(other.subAgg));
    }

    public static class AccOutputTransformImpl
    implements AccOutputTransform<I, O, P, SUBACC>,
    Serializable {
        private static final long serialVersionUID = 0L;
        protected SUBACC subAcc;
        protected Function<? super O, ? extends P> outputTransform;
        final /* synthetic */ AggOutputTransform this$0;

        public AccOutputTransformImpl(SUBACC subAcc, Function<? super O, ? extends P> outputTransform) {
            this.this$0 = this$0;
            this.subAcc = subAcc;
            this.outputTransform = outputTransform;
        }

        @Override
        public void accumulate(I input) {
            this.subAcc.accumulate(input);
        }

        @Override
        public SUBACC getSubAcc() {
            return this.subAcc;
        }

        @Override
        public P getValue() {
            Object rawResult = this.subAcc.getValue();
            Object result = this.outputTransform.apply(rawResult);
            return result;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31 * result + (this.outputTransform == null ? 0 : this.outputTransform.hashCode());
            result = 31 * result + (this.subAcc == null ? 0 : this.subAcc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AccOutputTransformImpl other = (AccOutputTransformImpl)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            if (this.outputTransform == null ? other.outputTransform != null : !this.outputTransform.equals(other.outputTransform)) {
                return false;
            }
            return !(this.subAcc == null ? other.subAcc != null : !this.subAcc.equals(other.subAcc));
        }

        private AggOutputTransform<?, ?, ?, ?, ?> getEnclosingInstance() {
            return this.this$0;
        }
    }

    public static interface AccOutputTransform<I, O, P, SUBACC extends Accumulator<I, O>>
    extends AccWrapper<I, P, SUBACC> {
    }
}

