/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collector.core;

import java.io.Serializable;
import java.util.function.Function;
import org.aksw.commons.collector.core.AccWrapper;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.collector.domain.ParallelAggregator;

public class AggInputTransform<I, J, O, SUBACC extends Accumulator<J, O>, SUBAGG extends ParallelAggregator<J, O, SUBACC>>
implements ParallelAggregator<I, O, AccInputTransform<I, J, O, SUBACC>>,
Serializable {
    private static final long serialVersionUID = 0L;
    protected SUBAGG subAgg;
    protected Function<? super I, ? extends J> inputTransform;

    public AggInputTransform(SUBAGG subAgg, Function<? super I, ? extends J> inputTransform) {
        this.subAgg = subAgg;
        this.inputTransform = inputTransform;
    }

    @Override
    public AccInputTransform<I, J, O, SUBACC> createAccumulator() {
        Object subAcc = this.subAgg.createAccumulator();
        return new AccTransformInputImpl(this, subAcc, this.inputTransform);
    }

    @Override
    public AccInputTransform<I, J, O, SUBACC> combine(AccInputTransform<I, J, O, SUBACC> a, AccInputTransform<I, J, O, SUBACC> b) {
        Accumulator accA = (Accumulator)a.getSubAcc();
        Accumulator accB = (Accumulator)b.getSubAcc();
        Accumulator combined = this.subAgg.combine((Accumulator)accA, (Accumulator)accB);
        return new AccTransformInputImpl(this, combined, this.inputTransform);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.inputTransform == null ? 0 : this.inputTransform.hashCode());
        result = 31 * result + (this.subAgg == null ? 0 : this.subAgg.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggInputTransform other = (AggInputTransform)obj;
        if (this.inputTransform == null ? other.inputTransform != null : !this.inputTransform.equals(other.inputTransform)) {
            return false;
        }
        return !(this.subAgg == null ? other.subAgg != null : !this.subAgg.equals(other.subAgg));
    }

    public static class AccTransformInputImpl
    implements AccInputTransform<I, J, O, SUBACC>,
    Serializable {
        private static final long serialVersionUID = 0L;
        protected SUBACC subAcc;
        protected Function<? super I, ? extends J> inputTransform;
        final /* synthetic */ AggInputTransform this$0;

        public AccTransformInputImpl(SUBACC subAcc, Function<? super I, ? extends J> inputTransform) {
            this.this$0 = this$0;
            this.subAcc = subAcc;
            this.inputTransform = inputTransform;
        }

        @Override
        public void accumulate(I input) {
            Object transformedInput = this.inputTransform.apply(input);
            this.subAcc.accumulate(transformedInput);
        }

        @Override
        public SUBACC getSubAcc() {
            return this.subAcc;
        }

        @Override
        public O getValue() {
            return this.subAcc.getValue();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31 * result + (this.inputTransform == null ? 0 : this.inputTransform.hashCode());
            result = 31 * result + (this.subAcc == null ? 0 : this.subAcc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AccTransformInputImpl other = (AccTransformInputImpl)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            if (this.inputTransform == null ? other.inputTransform != null : !this.inputTransform.equals(other.inputTransform)) {
                return false;
            }
            return !(this.subAcc == null ? other.subAcc != null : !this.subAcc.equals(other.subAcc));
        }

        private AggInputTransform<?, ?, ?, ?, ?> getEnclosingInstance() {
            return this.this$0;
        }
    }

    public static interface AccInputTransform<I, J, O, SUBACC extends Accumulator<J, O>>
    extends AccWrapper<I, O, SUBACC> {
    }
}

