/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collector.core;

import java.io.Serializable;
import java.util.function.Predicate;
import org.aksw.commons.collector.core.AccWrapper;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.collector.domain.ParallelAggregator;

public class AggInputFilter<I, O, SUBACC extends Accumulator<I, O>, SUBAGG extends ParallelAggregator<I, O, SUBACC>>
implements ParallelAggregator<I, O, AccInputFilter<I, O, SUBACC>>,
Serializable {
    private static final long serialVersionUID = 0L;
    protected SUBAGG subAgg;
    protected Predicate<? super I> inputFilter;

    public AggInputFilter(SUBAGG subAgg, Predicate<? super I> inputFilter) {
        this.subAgg = subAgg;
        this.inputFilter = inputFilter;
    }

    @Override
    public AccInputFilter<I, O, SUBACC> createAccumulator() {
        Object subAcc = this.subAgg.createAccumulator();
        return new AccFilterInputImpl(this, subAcc, this.inputFilter);
    }

    @Override
    public AccInputFilter<I, O, SUBACC> combine(AccInputFilter<I, O, SUBACC> a, AccInputFilter<I, O, SUBACC> b) {
        Accumulator accA = (Accumulator)a.getSubAcc();
        Accumulator accB = (Accumulator)b.getSubAcc();
        Accumulator combined = this.subAgg.combine((Accumulator)accA, (Accumulator)accB);
        return new AccFilterInputImpl(this, combined, this.inputFilter);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.inputFilter == null ? 0 : this.inputFilter.hashCode());
        result = 31 * result + (this.subAgg == null ? 0 : this.subAgg.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggInputFilter other = (AggInputFilter)obj;
        if (this.inputFilter == null ? other.inputFilter != null : !this.inputFilter.equals(other.inputFilter)) {
            return false;
        }
        return !(this.subAgg == null ? other.subAgg != null : !this.subAgg.equals(other.subAgg));
    }

    public static class AccFilterInputImpl
    implements AccInputFilter<I, O, SUBACC>,
    Serializable {
        private static final long serialVersionUID = 0L;
        protected SUBACC subAcc;
        protected Predicate<? super I> inputFilter;
        final /* synthetic */ AggInputFilter this$0;

        public AccFilterInputImpl(SUBACC subAcc, Predicate<? super I> inputFilter) {
            this.this$0 = this$0;
            this.subAcc = subAcc;
            this.inputFilter = inputFilter;
        }

        @Override
        public void accumulate(I input) {
            boolean isAccepted = this.inputFilter.test(input);
            if (isAccepted) {
                this.subAcc.accumulate(input);
            }
        }

        @Override
        public SUBACC getSubAcc() {
            return this.subAcc;
        }

        @Override
        public O getValue() {
            return this.subAcc.getValue();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31 * result + (this.inputFilter == null ? 0 : this.inputFilter.hashCode());
            result = 31 * result + (this.subAcc == null ? 0 : this.subAcc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AccFilterInputImpl other = (AccFilterInputImpl)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            if (this.inputFilter == null ? other.inputFilter != null : !this.inputFilter.equals(other.inputFilter)) {
                return false;
            }
            return !(this.subAcc == null ? other.subAcc != null : !this.subAcc.equals(other.subAcc));
        }

        private AggInputFilter<?, ?, ?, ?> getEnclosingInstance() {
            return this.this$0;
        }
    }

    public static interface AccInputFilter<I, O, SUBACC extends Accumulator<I, O>>
    extends AccWrapper<I, O, SUBACC> {
    }
}

