/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collector.core;

import java.io.Serializable;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.collector.domain.ParallelAggregator;

public class AggCounting<I>
implements ParallelAggregator<I, Long, Accumulator<I, Long>>,
Serializable {
    private static final long serialVersionUID = 0L;

    @Override
    public Accumulator<I, Long> createAccumulator() {
        return new AccCounting(0L);
    }

    @Override
    public Accumulator<I, Long> combine(Accumulator<I, Long> a, Accumulator<I, Long> b) {
        long count1 = a.getValue();
        long count2 = b.getValue();
        long newCount = count1 + count2;
        return new AccCounting(newCount);
    }

    public int hashCode() {
        return 41;
    }

    public boolean equals(Object other) {
        return other == null ? false : this.getClass() == other.getClass();
    }

    public class AccCounting
    implements Accumulator<I, Long>,
    Serializable {
        private static final long serialVersionUID = 0L;
        protected long count = 0L;

        public AccCounting(long count) {
            this.count = count;
        }

        @Override
        public void accumulate(I binding) {
            ++this.count;
        }

        @Override
        public Long getValue() {
            return this.count;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31 * result + (int)(this.count ^ this.count >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AccCounting other = (AccCounting)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            return this.count == other.count;
        }

        private AggCounting<?> getEnclosingInstance() {
            return AggCounting.this;
        }
    }
}

