/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.collector.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.DoubleSummaryStatistics;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collector;
import org.aksw.commons.collector.core.AccCollection;
import org.aksw.commons.collector.core.AggCounting;
import org.aksw.commons.collector.core.AggFromCollector;
import org.aksw.commons.collector.core.AggInputBroadcast;
import org.aksw.commons.collector.core.AggInputBroadcastMap;
import org.aksw.commons.collector.core.AggInputFilter;
import org.aksw.commons.collector.core.AggInputSplit;
import org.aksw.commons.collector.core.AggInputTransform;
import org.aksw.commons.collector.core.AggNatural;
import org.aksw.commons.collector.core.AggOutputTransform;
import org.aksw.commons.collector.core.AggReduce;
import org.aksw.commons.collector.core.SerializableCollectorImpl;
import org.aksw.commons.collector.domain.Accumulator;
import org.aksw.commons.collector.domain.Aggregator;
import org.aksw.commons.collector.domain.ParallelAggregator;
import org.aksw.commons.lambda.serializable.SerializableBiConsumer;
import org.aksw.commons.lambda.serializable.SerializableBiFunction;
import org.aksw.commons.lambda.serializable.SerializableBinaryOperator;
import org.aksw.commons.lambda.serializable.SerializableCollector;
import org.aksw.commons.lambda.serializable.SerializableFunction;
import org.aksw.commons.lambda.serializable.SerializablePredicate;
import org.aksw.commons.lambda.serializable.SerializableSupplier;
import org.aksw.commons.lambda.serializable.SerializableToDoubleFunction;
import org.aksw.commons.lambda.serializable.SerializableToIntFunction;
import org.aksw.commons.lambda.serializable.SerializableToLongFunction;
import org.aksw.commons.util.serializable.SerializableDoubleSummaryStatistics;
import org.aksw.commons.util.serializable.SerializableIntSummaryStatistics;
import org.aksw.commons.util.serializable.SerializableLongSummaryStatistics;

public class AggBuilder<I, O, ACC extends Accumulator<I, O>, AGG extends ParallelAggregator<I, O, ACC>> {
    static final Set<Collector.Characteristics> CH_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));
    protected AGG state;

    public static <I, O, ACC extends Accumulator<I, O>, AGG extends ParallelAggregator<I, O, ACC>> AggInputFilter<I, O, ACC, AGG> inputFilter(SerializablePredicate<? super I> inputFilter, AGG state) {
        return new AggInputFilter(state, inputFilter);
    }

    public static <I, K, J, O, ACC extends Accumulator<J, O>, AGG extends ParallelAggregator<J, O, ACC>> AggInputSplit<I, K, J, O, ACC, AGG> inputSplit(SerializableFunction<? super I, ? extends Set<? extends K>> keyMapper, SerializableBiFunction<? super I, ? super K, ? extends J> valueMapper, AGG state) {
        return new AggInputSplit(state, keyMapper, valueMapper);
    }

    public static <I, K, J, O, ACC extends Accumulator<J, O>, AGG extends ParallelAggregator<J, O, ACC>> AggInputSplit<I, K, J, O, ACC, AGG> inputSplit(Set<K> fixedKeys, boolean considerNewKeys, SerializableFunction<? super I, ? extends Set<? extends K>> keyMapper, SerializableBiFunction<? super I, ? super K, ? extends J> valueMapper, AGG state) {
        return new AggInputSplit(state, fixedKeys, considerNewKeys, keyMapper, valueMapper);
    }

    public static <I, K, O, ACC extends Accumulator<I, O>, AGG extends ParallelAggregator<I, O, ACC>> AggInputSplit<I, K, I, O, ACC, AGG> inputSplit(SerializableFunction<? super I, ? extends K> keyMapper, AGG state) {
        return new AggInputSplit(state, in -> Collections.singleton(keyMapper.apply(in)), (in, key) -> in);
    }

    public static <I, J, O, ACC extends Accumulator<J, O>, AGG extends ParallelAggregator<J, O, ACC>> AggInputTransform<I, J, O, ACC, AGG> inputTransform(SerializableFunction<? super I, ? extends J> inputTransform, AGG state) {
        return new AggInputTransform(state, inputTransform);
    }

    public static <I, O, P, ACC extends Accumulator<I, O>, AGG extends ParallelAggregator<I, O, ACC>> AggOutputTransform<I, O, P, ACC, AGG> outputTransform(AGG state, SerializableFunction<? super O, ? extends P> outputTransform) {
        return new AggOutputTransform(state, outputTransform);
    }

    public static <T> ParallelAggregator<T, Set<T>, Accumulator<T, Set<T>>> hashSetSupplier() {
        return AggBuilder.collectionSupplier(HashSet::new);
    }

    public static <T> ParallelAggregator<T, List<T>, Accumulator<T, List<T>>> arrayListSupplier() {
        return AggBuilder.collectionSupplier(ArrayList::new);
    }

    public static <T> ParallelAggregator<T, Set<T>, Accumulator<T, Set<T>>> setSupplier(SerializableSupplier<? extends Set<T>> setSupplier) {
        return AggBuilder.collectionSupplier(setSupplier);
    }

    public static <T, C extends Collection<T>> ParallelAggregator<T, C, Accumulator<T, C>> collectionSupplier(SerializableSupplier<? extends C> colSupplier) {
        return AggBuilder.naturalAccumulator((SerializableSupplier & Serializable)() -> new AccCollection((Collection)colSupplier.get()));
    }

    public static <T, C extends Collection<T>> ParallelAggregator<T, C, Accumulator<T, C>> naturalAccumulator(SerializableSupplier<? extends Accumulator<T, C>> accSupplier) {
        return new AggNatural(accSupplier);
    }

    public static <I> ParallelAggregator<I, Long, Accumulator<I, Long>> counting() {
        return new AggCounting();
    }

    public static <I, O1, O2> ParallelAggregator<I, Map.Entry<O1, O2>, ?> inputBroadcast(ParallelAggregator<I, O1, ?> agg1, ParallelAggregator<I, O2, ?> agg2) {
        return new AggInputBroadcast(agg1, agg2);
    }

    public static <I, K, O> AggInputBroadcastMap<I, K, O> inputBroadcastMap(Map<K, ParallelAggregator<I, O, ?>> subAggMap) {
        return new AggInputBroadcastMap<I, K, O>(subAggMap);
    }

    public static <I> ParallelAggregator<I, I, Accumulator<I, I>> fold(SerializableSupplier<I> zeroElementSupplier, SerializableBinaryOperator<I> plusOperator) {
        return new AggReduce<I>(zeroElementSupplier, plusOperator);
    }

    public static <T, R, A> AggFromCollector<T, R, A> fromCollector(SerializableSupplier<A> supplier, SerializableBiConsumer<A, T> accumulator, SerializableBinaryOperator<A> combiner, SerializableFunction<A, R> finisher) {
        return AggBuilder.fromCollector(supplier, accumulator, combiner, finisher, Collections.emptySet());
    }

    public static <T, R, A> AggFromCollector<T, R, A> fromCollector(SerializableSupplier<A> supplier, SerializableBiConsumer<A, T> accumulator, SerializableBinaryOperator<A> combiner, SerializableFunction<A, R> finisher, Set<Collector.Characteristics> characteristics) {
        SerializableCollectorImpl<T, A, R> collector = SerializableCollectorImpl.create(supplier, accumulator, combiner, finisher, characteristics);
        return AggBuilder.fromCollector(collector);
    }

    public static <T, A, R> AggFromCollector<T, R, A> fromCollector(SerializableCollector<T, A, R> collector) {
        return new AggFromCollector<T, R, A>(collector);
    }

    public static ParallelAggregator<Long, Long, Accumulator<Long, Long>> maxLong() {
        return AggBuilder.fold((SerializableSupplier & Serializable)() -> 0L, Math::max);
    }

    public static ParallelAggregator<Integer, Integer, Accumulator<Integer, Integer>> maxInteger() {
        return AggBuilder.fold((SerializableSupplier & Serializable)() -> 0, Math::max);
    }

    public static <T> AggFromCollector<T, SerializableIntSummaryStatistics, SerializableIntSummaryStatistics> summarizingInt(SerializableToIntFunction<T> mapper) {
        return AggBuilder.fromCollector(SerializableIntSummaryStatistics::new, (SerializableBiConsumer & Serializable)(r, t) -> r.accept(mapper.applyAsInt(t)), (SerializableBinaryOperator & Serializable)(l, r) -> {
            l.combine((IntSummaryStatistics)r);
            return l;
        }, (SerializableFunction & Serializable)x -> x, CH_ID);
    }

    public static <T> AggFromCollector<T, SerializableLongSummaryStatistics, SerializableLongSummaryStatistics> summarizingLong(SerializableToLongFunction<T> mapper) {
        return AggBuilder.fromCollector(SerializableLongSummaryStatistics::new, (SerializableBiConsumer & Serializable)(r, t) -> r.accept(mapper.applyAsLong(t)), (SerializableBinaryOperator & Serializable)(l, r) -> {
            l.combine((LongSummaryStatistics)r);
            return l;
        }, (SerializableFunction & Serializable)x -> x, CH_ID);
    }

    public static <T> AggFromCollector<T, SerializableDoubleSummaryStatistics, SerializableDoubleSummaryStatistics> summarizingDouble(SerializableToDoubleFunction<T> mapper) {
        return AggBuilder.fromCollector(SerializableDoubleSummaryStatistics::new, (SerializableBiConsumer & Serializable)(r, t) -> r.accept(mapper.applyAsDouble(t)), (SerializableBinaryOperator & Serializable)(l, r) -> {
            l.combine((DoubleSummaryStatistics)r);
            return l;
        }, (SerializableFunction & Serializable)x -> x, CH_ID);
    }

    public AggBuilder(AGG state) {
        this.state = state;
    }

    public AGG getFullyTyped() {
        return this.state;
    }

    public ParallelAggregator<I, O, ?> getAsParallelAggregator() {
        return this.state;
    }

    public Aggregator<I, O> getAsAggregator() {
        return this.state;
    }

    public static <I, O, ACC extends Accumulator<I, O>, AGG extends ParallelAggregator<I, O, ACC>> AggBuilder<I, O, ACC, AGG> from(AGG agg) {
        return new AggBuilder<I, O, ACC, AGG>(agg);
    }

    public static <T, C extends Collection<T>> AggBuilder<T, C, Accumulator<T, C>, ParallelAggregator<T, C, Accumulator<T, C>>> fromNaturalAccumulator(SerializableSupplier<? extends Accumulator<T, C>> accSupplier) {
        return AggBuilder.from(new AggNatural(accSupplier));
    }

    public static <T, C extends Collection<T>> AggBuilder<T, C, Accumulator<T, C>, ParallelAggregator<T, C, Accumulator<T, C>>> fromCollectionSupplier(SerializableSupplier<C> colSupplier) {
        return AggBuilder.fromNaturalAccumulator((SerializableSupplier & Serializable)() -> new AccCollection((Collection)colSupplier.get()));
    }

    public AggBuilder<I, O, AggInputFilter.AccInputFilter<I, O, ACC>, AggInputFilter<I, O, ACC, AGG>> withInputFilter(SerializablePredicate<? super I> inputFilter) {
        return AggBuilder.from(new AggInputFilter(this.state, inputFilter));
    }

    public <H> AggBuilder<H, O, AggInputTransform.AccInputTransform<H, I, O, ACC>, AggInputTransform<H, I, O, ACC, AGG>> withInputTransform(SerializableFunction<? super H, ? extends I> inputTransform) {
        return AggBuilder.from(new AggInputTransform(this.state, inputTransform));
    }

    public <H, K> AggBuilder<H, Map<K, O>, AggInputSplit.AccInputSplit<H, K, I, O, ACC>, AggInputSplit<H, K, I, O, ACC, AGG>> withInputSplit(SerializableFunction<? super H, ? extends Set<? extends K>> keyMapper, SerializableBiFunction<? super H, ? super K, ? extends I> valueMapper) {
        return AggBuilder.from(new AggInputSplit(this.state, keyMapper, valueMapper));
    }

    public <P> AggBuilder<I, P, AggOutputTransform.AccOutputTransform<I, O, P, ACC>, AggOutputTransform<I, O, P, ACC, AGG>> withOutputTransform(SerializableFunction<? super O, ? extends P> outputTransform) {
        return AggBuilder.from(new AggOutputTransform(this.state, outputTransform));
    }
}

