/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.workflow.simple.definition.form;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.List;
import org.activiti.workflow.simple.definition.form.FormPropertyDefinition;
import org.activiti.workflow.simple.definition.form.FormPropertyDefinitionContainer;
import org.activiti.workflow.simple.definition.form.FormPropertyGroup;
import org.activiti.workflow.simple.exception.SimpleWorkflowException;

public class FormDefinition
implements FormPropertyDefinitionContainer {
    protected String description;
    protected String formKey;
    protected List<FormPropertyDefinition> formProperties = new ArrayList<FormPropertyDefinition>();
    protected List<FormPropertyGroup> formGroups = new ArrayList<FormPropertyGroup>();

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @JsonDeserialize(contentAs=FormPropertyDefinition.class)
    @JsonProperty(value="formProperties")
    public List<FormPropertyDefinition> getFormPropertyDefinitions() {
        return this.formProperties;
    }

    public void getFormPropertyDefinitions(List<FormPropertyDefinition> formProperties) {
        this.formProperties = formProperties;
    }

    @Override
    public void addFormProperty(FormPropertyDefinition definition) {
        this.formProperties.add(definition);
    }

    @Override
    public boolean removeFormProperty(FormPropertyDefinition definition) {
        return this.formProperties.remove(definition);
    }

    @JsonSerialize(contentAs=FormPropertyGroup.class)
    public List<FormPropertyGroup> getFormGroups() {
        return this.formGroups;
    }

    public void setFormGroups(List<FormPropertyGroup> formGroups) {
        this.formGroups = formGroups;
    }

    public void addFormPropertyGroup(FormPropertyGroup group) {
        this.formGroups.add(group);
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public FormDefinition clone() {
        FormDefinition clone = new FormDefinition();
        clone.setValues(this);
        return clone;
    }

    public void setValues(FormDefinition otherDefinition) {
        if (!(otherDefinition instanceof FormDefinition)) {
            throw new SimpleWorkflowException("An instance of FormDefinition is required to set values");
        }
        FormDefinition formDefinition = otherDefinition;
        this.setFormKey(formDefinition.getFormKey());
        this.setDescription(formDefinition.getDescription());
        ArrayList<FormPropertyGroup> groupList = new ArrayList<FormPropertyGroup>();
        if (formDefinition.getFormGroups() != null && !formDefinition.getFormGroups().isEmpty()) {
            for (FormPropertyGroup propertyGroup : formDefinition.getFormGroups()) {
                groupList.add(propertyGroup.clone());
            }
        }
        this.setFormGroups(groupList);
        this.formProperties = new ArrayList<FormPropertyDefinition>();
        if (formDefinition.getFormGroups() != null && !formDefinition.getFormGroups().isEmpty()) {
            for (FormPropertyDefinition propertyDefinition : formDefinition.getFormPropertyDefinitions()) {
                this.formProperties.add(propertyDefinition.clone());
            }
        }
    }
}

