/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.workflow.simple.definition.form;

import java.util.List;

/**
 * Interface describing a container that can hold an ordered collection of 
 * form-property definitions.
 * 
 * @author Frederik Heremans
 */
public interface FormPropertyDefinitionContainer {

	/**
	 * @return all definitions present in the container.
	 */
	List<FormPropertyDefinition> getFormPropertyDefinitions();
	
	/**
	 * @param definition the form-property to add to the container.
	 */
	void addFormProperty(FormPropertyDefinition definition);
	
	/**
	 * @param definition the definition to remove from the container.
	 * @return true, if the definition was present in the container and was removed.
	 */
	boolean removeFormProperty(FormPropertyDefinition definition);
}
