/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.workflow.simple.converter.step;

import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.workflow.simple.converter.WorkflowDefinitionConversion;
import org.activiti.workflow.simple.converter.step.BaseStepDefinitionConverter;
import org.activiti.workflow.simple.definition.HumanStepAssignment;
import org.activiti.workflow.simple.definition.HumanStepDefinition;
import org.activiti.workflow.simple.definition.StepDefinition;
import org.activiti.workflow.simple.definition.form.FormDefinition;

public class HumanStepDefinitionConverter
extends BaseStepDefinitionConverter<HumanStepDefinition, UserTask> {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_INITIATOR_VARIABLE = "initiator";
    private static final String DEFAULT_INITIATOR_ASSIGNEE_EXPRESSION = "${initiator}";

    @Override
    public Class<? extends StepDefinition> getHandledClass() {
        return HumanStepDefinition.class;
    }

    @Override
    protected UserTask createProcessArtifact(HumanStepDefinition stepDefinition, WorkflowDefinitionConversion conversion) {
        UserTask userTask = this.createUserTask(stepDefinition, conversion);
        this.addFlowElement(conversion, (FlowElement)userTask, true);
        return userTask;
    }

    protected UserTask createUserTask(HumanStepDefinition humanStepDefinition, WorkflowDefinitionConversion conversion) {
        UserTask userTask = new UserTask();
        userTask.setId(conversion.getUniqueNumberedId("userTask"));
        userTask.setName(humanStepDefinition.getName());
        userTask.setDocumentation(humanStepDefinition.getDescription());
        if (humanStepDefinition.getAssignmentType() == HumanStepAssignment.HumanStepAssignmentType.INITIATOR) {
            userTask.setAssignee(this.getInitiatorExpression());
            for (StartEvent startEvent : conversion.getProcess().findFlowElementsOfType(StartEvent.class)) {
                startEvent.setInitiator(this.getInitiatorVariable());
            }
        } else if (humanStepDefinition.getAssignmentType() == HumanStepAssignment.HumanStepAssignmentType.USER) {
            userTask.setAssignee(humanStepDefinition.getAssignee());
        }
        if (humanStepDefinition.getAssignmentType() == HumanStepAssignment.HumanStepAssignmentType.USERS || humanStepDefinition.getAssignmentType() == HumanStepAssignment.HumanStepAssignmentType.MIXED) {
            userTask.setCandidateUsers(humanStepDefinition.getCandidateUsers());
        }
        if (humanStepDefinition.getAssignmentType() == HumanStepAssignment.HumanStepAssignmentType.GROUPS || humanStepDefinition.getAssignmentType() == HumanStepAssignment.HumanStepAssignmentType.MIXED) {
            userTask.setCandidateGroups(humanStepDefinition.getCandidateGroups());
        }
        if (humanStepDefinition.getForm() != null) {
            FormDefinition formDefinition = humanStepDefinition.getForm();
            userTask.setFormProperties(this.convertProperties(formDefinition));
            if (formDefinition.getFormKey() != null) {
                userTask.setFormKey(formDefinition.getFormKey());
            }
        }
        return userTask;
    }

    protected String getInitiatorVariable() {
        return DEFAULT_INITIATOR_VARIABLE;
    }

    protected String getInitiatorExpression() {
        return DEFAULT_INITIATOR_ASSIGNEE_EXPRESSION;
    }
}

