/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.HashMap;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.history.HistoricIdentityLink;
import org.activiti.engine.impl.db.BulkDeleteable;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;

public class HistoricIdentityLinkEntity
implements Serializable,
HistoricIdentityLink,
BulkDeleteable,
PersistentObject {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String type;
    protected String userId;
    protected String groupId;
    protected String taskId;
    protected String processInstanceId;

    public HistoricIdentityLinkEntity(IdentityLinkEntity identityLink) {
        this.id = identityLink.getId();
        this.groupId = identityLink.getGroupId();
        this.processInstanceId = identityLink.getProcessInstanceId();
        this.taskId = identityLink.getTaskId();
        this.type = identityLink.getType();
        this.userId = identityLink.getUserId();
    }

    public HistoricIdentityLinkEntity() {
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, String> persistentState = new HashMap<String, String>();
        persistentState.put("id", this.id);
        persistentState.put("type", this.type);
        if (this.userId != null) {
            persistentState.put("userId", this.userId);
        }
        if (this.groupId != null) {
            persistentState.put("groupId", this.groupId);
        }
        if (this.taskId != null) {
            persistentState.put("taskId", this.taskId);
        }
        if (this.processInstanceId != null) {
            persistentState.put("processInstanceId", this.processInstanceId);
        }
        return persistentState;
    }

    public boolean isUser() {
        return this.userId != null;
    }

    public boolean isGroup() {
        return this.groupId != null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        if (this.groupId != null && userId != null) {
            throw new ActivitiException("Cannot assign a userId to a task assignment that already has a groupId");
        }
        this.userId = userId;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        if (this.userId != null && groupId != null) {
            throw new ActivitiException("Cannot assign a groupId to a task assignment that already has a userId");
        }
        this.groupId = groupId;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public Long getLongId() {
        return this.id == null ? null : Long.valueOf(Long.parseLong(this.id));
    }

    public void setLongId(Long id) {
        this.id = id == null ? null : id.toString();
    }

    public Long getLongProcessInstanceId() {
        return this.processInstanceId == null ? null : Long.valueOf(Long.parseLong(this.processInstanceId));
    }

    public void setLongProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId == null ? null : processInstanceId.toString();
    }

    public Long getLongTaskId() {
        return this.taskId == null ? null : Long.valueOf(Long.parseLong(this.taskId));
    }

    public void setLongTaskId(Long taskId) {
        this.taskId = taskId == null ? null : taskId.toString();
    }
}

