/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Event;

public class CommentEntityManager
extends AbstractManager {
    @Override
    public void delete(PersistentObject persistentObject) {
        this.checkHistoryEnabled();
        super.delete(persistentObject);
        Comment comment = (Comment)((Object)persistentObject);
        if (this.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            ExecutionEntity process;
            String processDefinitionId = null;
            String processInstanceId = comment.getProcessInstanceId();
            if (comment.getProcessInstanceId() != null && (process = this.getProcessInstanceManager().findExecutionById(comment.getProcessInstanceId())) != null) {
                processDefinitionId = process.getProcessDefinitionId();
            }
            this.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, persistentObject, processInstanceId, processInstanceId, processDefinitionId));
        }
    }

    @Override
    public void insert(PersistentObject persistentObject) {
        this.checkHistoryEnabled();
        super.insert(persistentObject);
        Comment comment = (Comment)((Object)persistentObject);
        if (this.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            ExecutionEntity process;
            String processDefinitionId = null;
            String processInstanceId = comment.getProcessInstanceId();
            if (comment.getProcessInstanceId() != null && (process = this.getProcessInstanceManager().findExecutionById(comment.getProcessInstanceId())) != null) {
                processDefinitionId = process.getProcessDefinitionId();
            }
            this.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, persistentObject, processInstanceId, processInstanceId, processDefinitionId));
            this.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_INITIALIZED, persistentObject, processInstanceId, processInstanceId, processDefinitionId));
        }
    }

    public List<Comment> findCommentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        return this.getDbSqlSession().selectList("selectCommentsByTaskId", taskId);
    }

    public List<Comment> findCommentsByTaskIdAndType(String taskId, String type) {
        this.checkHistoryEnabled();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskId", taskId);
        params.put("type", type);
        return this.getDbSqlSession().selectListWithRawParameter("selectCommentsByTaskIdAndType", params, 0, Integer.MAX_VALUE);
    }

    public List<Comment> findCommentsByType(String type) {
        this.checkHistoryEnabled();
        return this.getDbSqlSession().selectList("selectCommentsByType", type);
    }

    public List<Event> findEventsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        return this.getDbSqlSession().selectList("selectEventsByTaskId", taskId);
    }

    public List<Event> findEventsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        return this.getDbSqlSession().selectList("selectEventsByProcessInstanceId", processInstanceId);
    }

    public void deleteCommentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        this.getDbSqlSession().delete("deleteCommentsByTaskId", taskId == null ? null : Long.valueOf(Long.parseLong(taskId)));
    }

    public void deleteCommentsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        this.getDbSqlSession().delete("deleteCommentsByProcessInstanceId", processInstanceId == null ? null : Long.valueOf(Long.parseLong(processInstanceId)));
    }

    public List<Comment> findCommentsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        return this.getDbSqlSession().selectList("selectCommentsByProcessInstanceId", processInstanceId);
    }

    public List<Comment> findCommentsByProcessInstanceId(String processInstanceId, String type) {
        this.checkHistoryEnabled();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processInstanceId", processInstanceId);
        params.put("type", type);
        return this.getDbSqlSession().selectListWithRawParameter("selectCommentsByProcessInstanceIdAndType", params, 0, Integer.MAX_VALUE);
    }

    public Comment findComment(String commentId) {
        return this.getDbSqlSession().selectById(CommentEntity.class, commentId);
    }

    public Event findEvent(String commentId) {
        return this.getDbSqlSession().selectById(CommentEntity.class, commentId);
    }

    protected void checkHistoryEnabled() {
        if (!this.getHistoryManager().isHistoryEnabled()) {
            throw new ActivitiException("In order to use comments, history should be enabled");
        }
    }
}

