/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.BulkDeleteable;
import org.activiti.engine.impl.db.HasRevision;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.JobHandler;
import org.activiti.engine.impl.persistence.entity.ByteArrayRef;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.runtime.Job;
import org.apache.commons.lang3.StringUtils;

public abstract class JobEntity
implements Job,
PersistentObject,
HasRevision,
BulkDeleteable,
Serializable {
    public static final boolean DEFAULT_EXCLUSIVE = true;
    public static final int DEFAULT_RETRIES = 3;
    private static final int MAX_EXCEPTION_MESSAGE_LENGTH = 255;
    private static final long serialVersionUID = 1L;
    protected String id;
    protected int revision;
    protected Date duedate;
    protected String lockOwner = null;
    protected Date lockExpirationTime = null;
    protected String executionId = null;
    protected String processInstanceId = null;
    protected String processDefinitionId = null;
    protected boolean isExclusive = true;
    protected int retries = 3;
    protected String jobHandlerType = null;
    protected String jobHandlerConfiguration = null;
    protected final ByteArrayRef exceptionByteArrayRef = new ByteArrayRef();
    protected String exceptionMessage;
    protected String tenantId = "";
    protected String jobType;

    public void execute(CommandContext commandContext) {
        ExecutionEntity execution = null;
        if (this.executionId != null) {
            execution = commandContext.getExecutionEntityManager().findExecutionById(this.executionId);
        }
        Map<String, JobHandler> jobHandlers = Context.getProcessEngineConfiguration().getJobHandlers();
        JobHandler jobHandler = jobHandlers.get(this.jobHandlerType);
        jobHandler.execute(this, this.jobHandlerConfiguration, execution, commandContext);
    }

    public void insert() {
        Context.getCommandContext().getDbSqlSession().insert(this);
        if (this.executionId != null) {
            ExecutionEntity execution = Context.getCommandContext().getExecutionEntityManager().findExecutionById(this.executionId);
            execution.addJob(this);
            if (execution.getTenantId() != null) {
                this.setTenantId(execution.getTenantId());
            }
        }
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, this));
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_INITIALIZED, this));
        }
    }

    public void delete() {
        Context.getCommandContext().getDbSqlSession().delete(this);
        this.exceptionByteArrayRef.delete();
        if (this.executionId != null) {
            ExecutionEntity execution = Context.getCommandContext().getExecutionEntityManager().findExecutionById(this.executionId);
            execution.removeJob(this);
        }
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, this));
        }
    }

    public void setExecution(ExecutionEntity execution) {
        this.executionId = execution.getId();
        this.processInstanceId = execution.getProcessInstanceId();
        this.processDefinitionId = execution.getProcessDefinitionId();
        execution.addJob(this);
    }

    public String getExceptionStacktrace() {
        byte[] bytes = this.exceptionByteArrayRef.getBytes();
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ActivitiException("UTF-8 is not a supported encoding");
        }
    }

    public void setExceptionStacktrace(String exception) {
        this.exceptionByteArrayRef.setValue("stacktrace", this.getUtf8Bytes(exception));
    }

    private byte[] getUtf8Bytes(String str) {
        if (str == null) {
            return null;
        }
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ActivitiException("UTF-8 is not a supported encoding");
        }
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("lockOwner", this.lockOwner);
        persistentState.put("lockExpirationTime", this.lockExpirationTime);
        persistentState.put("retries", this.retries);
        persistentState.put("duedate", this.duedate);
        persistentState.put("exceptionMessage", this.exceptionMessage);
        persistentState.put("exceptionByteArrayId", this.exceptionByteArrayRef.getId());
        return persistentState;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public Date getDuedate() {
        return this.duedate;
    }

    public void setDuedate(Date duedate) {
        this.duedate = duedate;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public void setLockOwner(String claimedBy) {
        this.lockOwner = claimedBy;
    }

    public Date getLockExpirationTime() {
        return this.lockExpirationTime;
    }

    public void setLockExpirationTime(Date claimedUntil) {
        this.lockExpirationTime = claimedUntil;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public boolean isExclusive() {
        return this.isExclusive;
    }

    public void setExclusive(boolean isExclusive) {
        this.isExclusive = isExclusive;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public String getJobHandlerType() {
        return this.jobHandlerType;
    }

    public void setJobHandlerType(String jobHandlerType) {
        this.jobHandlerType = jobHandlerType;
    }

    public String getJobHandlerConfiguration() {
        return this.jobHandlerConfiguration;
    }

    public void setJobHandlerConfiguration(String jobHandlerConfiguration) {
        this.jobHandlerConfiguration = jobHandlerConfiguration;
    }

    @Override
    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = StringUtils.abbreviate((String)exceptionMessage, (int)255);
    }

    public String getJobType() {
        return this.jobType;
    }

    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String toString() {
        return "JobEntity [id=" + this.id + "]";
    }

    public Long getLongId() {
        return this.id == null ? null : Long.valueOf(Long.parseLong(this.id));
    }

    public void setLongId(Long id) {
        this.id = id == null ? null : id.toString();
    }

    public Long getLongProcessInstanceId() {
        return this.processInstanceId == null ? null : Long.valueOf(Long.parseLong(this.processInstanceId));
    }

    public void setLongProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId == null ? null : processInstanceId.toString();
    }

    public Long getLongExecutionId() {
        return this.executionId == null ? null : Long.valueOf(Long.parseLong(this.executionId));
    }

    public void setLongExecutionId(Long executionId) {
        this.executionId = executionId == null ? null : executionId.toString();
    }
}

